/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

public class TranslationUtils {
    private final Map requestMap = Maps.newHashMap();
    public boolean isUnicode = false;
    private String languageId = "en_US";
    private String modId;
    private String encoding;
    private Map translationMap = Maps.newHashMap();
    private boolean usingJson = false;

    public TranslationUtils() {
        this(false);
    }

    public TranslationUtils(boolean useJson) {
        this("", useJson);
    }

    public TranslationUtils(String modId) {
        this(modId, false);
    }

    public TranslationUtils(String modId, boolean useJson) {
        this(modId, useJson, "UTF-8");
    }

    public TranslationUtils(String modId, boolean useJson, String encoding) {
        this.setLanguage(CraftPresence.CONFIG != null ? CraftPresence.CONFIG.languageId : this.languageId);
        this.setModId(modId);
        this.setUsingJson(useJson);
        this.setEncoding(encoding);
        this.getTranslationMap(encoding);
        this.checkUnicode();
    }

    public static String convertId(String originalId, ConversionMode mode) {
        String resultId = originalId;
        if (originalId.length() == 5 && originalId.contains("_")) {
            if (mode == ConversionMode.PackFormat2 || mode == ConversionMode.None) {
                resultId = resultId.substring(0, 3).toLowerCase() + resultId.substring(3).toUpperCase();
            } else if (mode == ConversionMode.PackFormat3 || mode == ConversionMode.None) {
                resultId = resultId.toLowerCase();
            }
        }
        if (resultId.equals(originalId) && mode != ConversionMode.None) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", resultId, mode.name()), new Object[0]);
        }
        return resultId.trim();
    }

    void onTick() {
        if (!(CraftPresence.CONFIG == null || this.languageId.equals(CraftPresence.CONFIG.languageId) || this.requestMap.containsKey(CraftPresence.CONFIG.languageId) && !((Boolean)this.requestMap.get(CraftPresence.CONFIG.languageId)).booleanValue())) {
            this.setLanguage(CraftPresence.CONFIG.languageId);
            this.getTranslationMap(this.encoding);
            this.checkUnicode();
        }
    }

    private void checkUnicode() {
        this.isUnicode = false;
        int extendedCharCount = 0;
        int totalLength = 0;
        for (String currentString : this.translationMap.values()) {
            int currentLength = currentString.length();
            totalLength += currentLength;
            for (int index = 0; index < currentLength; ++index) {
                if (currentString.charAt(index) < '\u0100') continue;
                ++extendedCharCount;
            }
        }
        float f = (float)extendedCharCount / (float)totalLength;
        this.isUnicode = (double)f > 0.1;
    }

    private void setUsingJson(boolean usingJson) {
        this.usingJson = usingJson;
    }

    private void setLanguage(String languageId) {
        this.languageId = !StringUtils.isNullOrEmpty(languageId) ? languageId : "en_US";
    }

    private void setEncoding(String encoding) {
        this.encoding = !StringUtils.isNullOrEmpty(encoding) ? encoding : "UTF-8";
    }

    private void setModId(String modId) {
        this.modId = !StringUtils.isNullOrEmpty(modId) ? modId : null;
    }

    private void getTranslationMap(String encoding) {
        this.translationMap = Maps.newHashMap();
        InputStream in = FileUtils.getResourceAsStream(TranslationUtils.class, "/assets/" + (!StringUtils.isNullOrEmpty(this.modId) ? this.modId + "/" : "") + "lang/" + this.languageId + (this.usingJson ? ".json" : ".lang"));
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName(encoding)));
            try {
                String currentString;
                while ((currentString = reader.readLine()) != null) {
                    String[] splitTranslation;
                    if ((currentString = currentString.trim()).startsWith("#") || currentString.startsWith("[{}]") || !(this.usingJson ? currentString.contains(":") : currentString.contains("="))) continue;
                    String[] stringArray = splitTranslation = this.usingJson ? currentString.split(":", 2) : currentString.split("=", 2);
                    if (this.usingJson) {
                        String str1 = splitTranslation[0].substring(1, splitTranslation[0].length() - 1).replace("\\n", "\n").replace("\\", "").trim();
                        String str2 = splitTranslation[1].substring(2, splitTranslation[1].length() - 2).replace("\\n", "\n").replace("\\", "").trim();
                        this.translationMap.put(str1, str2);
                        continue;
                    }
                    this.translationMap.put(splitTranslation[0].trim(), splitTranslation[1].trim());
                }
                in.close();
            }
            catch (Exception ex) {
                ModUtils.LOG.error("An Exception has occurred while Loading Translation Mappings, things may not work well...", new Object[0]);
                ex.printStackTrace();
            }
        } else {
            ModUtils.LOG.error("Translations for " + this.modId + " do not exist for " + this.languageId, new Object[0]);
            this.requestMap.put(this.languageId, false);
            this.setLanguage("en_US");
        }
    }

    public String translate(boolean stripColors, String translationKey, Object ... parameters) {
        boolean hasError = false;
        String translatedString = translationKey;
        try {
            if (this.translationMap.containsKey(translationKey)) {
                String rawString = (String)this.translationMap.get(translationKey);
                translatedString = parameters.length > 0 ? String.format(rawString, parameters) : rawString;
            } else {
                hasError = true;
            }
        }
        catch (Exception ex) {
            ModUtils.LOG.error("Exception parsing " + translationKey, new Object[0]);
            ex.printStackTrace();
            hasError = true;
        }
        if (hasError) {
            ModUtils.LOG.error("Unable to retrieve a translation for " + translationKey, new Object[0]);
        }
        return stripColors ? StringUtils.stripColors(translatedString) : translatedString;
    }

    public String translate(String translationKey, Object ... parameters) {
        return this.translate(CraftPresence.CONFIG != null && CraftPresence.CONFIG.stripTranslationColors, translationKey, parameters);
    }

    public static enum ConversionMode {
        PackFormat2,
        PackFormat3,
        None,
        Unknown;

    }
}

