/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private final List clearKeys = Lists.newArrayList();
    private final List invalidKeys = Lists.newArrayList();
    private final Map KEY_MAPPINGS = Maps.newHashMap();

    void register() {
        this.clearKeys.add(1);
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple(new ava("key.craftpresence.config_keycode.name", CraftPresence.CONFIG.configKeyCode), new Runnable(){

            @Override
            public void run() {
                if (!CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.configGUIOpened) {
                    CraftPresence.GUIS.openScreen(new MainGui(CraftPresence.instance.s));
                }
            }
        }, new DataConsumer(){

            public void accept(Throwable throwable) {
            }
        }));
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            CraftPresence.instance.z.W = (ava[])ArrayUtils.add(CraftPresence.instance.z.W, ((Tuple)this.KEY_MAPPINGS.get(keyName)).getFirst());
        }
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return !this.invalidKeys.contains(sourceKeyCode);
    }

    public boolean isValidClearCode(int sourceKeyCode) {
        return this.clearKeys.contains(sourceKeyCode);
    }

    public Map getRawKeyMappings() {
        return this.KEY_MAPPINGS;
    }

    public String getKeyName(String original) {
        String unknownKeyName = (String)((Pair)KeyConverter.fromGlfw.get(-1)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair integerData = StringUtils.getValidInteger(original);
            if (((Boolean)integerData.getFirst()).booleanValue()) {
                return this.getKeyName((Integer)integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    public String getKeyName(int original) {
        int unknownKeyCode = -1;
        String unknownKeyName = (String)((Pair)KeyConverter.fromGlfw.get(-1)).getSecond();
        if (this.isValidKeyCode(original)) {
            if (KeyConverter.toGlfw.containsKey(original)) {
                return (String)((Pair)KeyConverter.toGlfw.get(original)).getSecond();
            }
            String altKeyName = Integer.toString(original);
            String keyName = original != -1 ? Keyboard.getKeyName((int)original) : unknownKeyName;
            if (!StringUtils.isNullOrEmpty(keyName)) {
                return keyName;
            }
            return altKeyName;
        }
        return unknownKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTick() {
        block14: {
            if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
                int unknownKeyCode = -1;
                String unknownKeyName = (String)((Pair)KeyConverter.fromGlfw.get(-1)).getSecond();
                try {
                    for (String keyName : this.KEY_MAPPINGS.keySet()) {
                        ava keyBind = (ava)((Tuple)this.KEY_MAPPINGS.get(keyName)).getFirst();
                        int currentBind = keyBind.d;
                        boolean hasBeenRun = false;
                        if (!this.getKeyName(currentBind).equals(unknownKeyName) && !this.isValidClearCode(currentBind) && Keyboard.isKeyDown((int)currentBind) && !(CraftPresence.instance.s instanceof awl)) {
                            Tuple keyData = (Tuple)this.KEY_MAPPINGS.get(keyName);
                            try {
                                ((Runnable)keyData.getSecond()).run();
                            }
                            catch (Error | Exception ex) {
                                if (keyData.getThird() != null) {
                                    ((DataConsumer)keyData.getThird()).accept(ex);
                                } else {
                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.c), new Object[0]);
                                    this.syncKeyData(keyName, ImportMode.Specific, keyBind.d);
                                }
                            }
                            finally {
                                hasBeenRun = true;
                            }
                        }
                        if (hasBeenRun || CraftPresence.CONFIG.hasChanged) continue;
                        if (CraftPresence.CONFIG.keySyncQueue.containsKey(keyName)) {
                            this.syncKeyData(keyName, ImportMode.Config, (Integer)CraftPresence.CONFIG.keySyncQueue.get(keyName));
                            CraftPresence.CONFIG.keySyncQueue.remove(keyName);
                            continue;
                        }
                        if (currentBind == (Integer)StringUtils.getValidInteger(StringUtils.lookupObject(ConfigUtils.class, CraftPresence.CONFIG, keyName)).getSecond()) continue;
                        this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                    }
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break block14;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData;
        Tuple tuple = keyData = this.KEY_MAPPINGS.containsKey(keyName) ? (Tuple)this.KEY_MAPPINGS.get(keyName) : null;
        if (keyData != null) {
            if (mode == ImportMode.Config) {
                ((ava)keyData.getFirst()).d = keyCode;
            } else if (mode == ImportMode.Vanilla) {
                StringUtils.updateField(ConfigUtils.class, CraftPresence.CONFIG, new Tuple(keyName, keyCode, null));
                CraftPresence.CONFIG.updateConfig(false);
            } else if (mode == ImportMode.Specific) {
                this.syncKeyData(((ava)keyData.getFirst()).c, ImportMode.Config, keyCode);
                this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
            } else if (ModUtils.IS_VERBOSE) {
                ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
            }
        }
    }

    public Map getKeyMappings(FilterMode mode, List filterData) {
        HashMap filteredMappings = Maps.newHashMap();
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple keyData = (Tuple)this.KEY_MAPPINGS.get(keyName);
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(((ava)keyData.getFirst()).c) || mode == FilterMode.Id && filterData.contains(((ava)keyData.getFirst()).c)) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, Lists.newArrayList());
    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }
}

