/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageUtils {
    private static final BlockingQueue urlRequests = Queues.newLinkedBlockingQueue();
    private static final Map cachedImages = Maps.newHashMap();
    private static final Thread urlQueue = new Thread("Url Queue"){

        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (!CraftPresence.closing) {
                        Pair request = (Pair)urlRequests.take();
                        boolean isGif = ((String)request.getFirst()).endsWith(".gif");
                        Pair bufferData = (Pair)((Tuple)cachedImages.get(request.getFirst())).getSecond();
                        if (bufferData == null) continue;
                        try {
                            InputStream streamData;
                            Object originData = ((Pair)request.getSecond()).getSecond();
                            switch ((InputType)((Object)((Pair)request.getSecond()).getFirst())) {
                                case FileData: {
                                    streamData = new FileInputStream((File)originData);
                                    break;
                                }
                                case FileStream: {
                                    streamData = new FileInputStream(originData.toString());
                                    break;
                                }
                                case ByteStream: {
                                    Tuple base64Data = StringUtils.isBase64(originData.toString());
                                    byte[] dataSet = (Boolean)base64Data.getFirst() != false ? ImageUtils.decodeBase64((String)base64Data.getThird(), "UTF-8", false, false) : (originData instanceof byte[] ? (byte[])originData : originData.toString().getBytes());
                                    streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                    isGif = ((String)base64Data.getSecond()).contains("gif");
                                    break;
                                }
                                case Url: {
                                    streamData = UrlUtils.getURLStream((URL)originData);
                                    break;
                                }
                                default: {
                                    streamData = null;
                                }
                            }
                            if (streamData == null) continue block12;
                            if (isGif) {
                                ImageFrame[] frames;
                                for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                    try {
                                        ((List)bufferData.getSecond()).add(frame);
                                    }
                                    catch (Exception ex) {
                                        if (!ModUtils.IS_VERBOSE) continue;
                                        ex.printStackTrace();
                                    }
                                }
                            } else {
                                ((List)bufferData.getSecond()).add(new ImageFrame(ImageIO.read(streamData)));
                            }
                            ((Tuple)cachedImages.get(request.getFirst())).setSecond(bufferData);
                            ((Tuple)cachedImages.get(request.getFirst())).setThird(new ArrayList(((List)bufferData.getSecond()).size()));
                            continue block12;
                        }
                        catch (Exception ex) {
                            if (!ModUtils.IS_VERBOSE) continue;
                            ex.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break;
                    ex.printStackTrace();
                    break;
                }
            }
        }
    };

    public static String getTextureFromUrl(String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new URL(url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return "";
        }
    }

    public static String getTextureFromUrl(String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair((Object)InputType.Url, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return "";
        }
    }

    public static String getTextureFromUrl(String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair((Object)InputType.FileData, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return "";
        }
    }

    public static String getTextureFromUrl(String textureName, Object url) {
        if (url instanceof File) {
            return ImageUtils.getTextureFromUrl(textureName, (File)url);
        }
        if (url instanceof URL) {
            return ImageUtils.getTextureFromUrl(textureName, (URL)url);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(textureName, new Pair((Object)((Boolean)StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream), url.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextureFromUrl(String textureName, Pair stream) {
        Map map = cachedImages;
        synchronized (map) {
            Pair bufferData;
            block13: {
                if (!cachedImages.containsKey(textureName)) {
                    cachedImages.put(textureName, new Tuple(stream, new Pair(0, Lists.newArrayList()), null));
                    try {
                        urlRequests.put(new Pair(textureName, stream));
                    }
                    catch (Exception ex) {
                        if (!ModUtils.IS_VERBOSE) break block13;
                        ex.printStackTrace();
                    }
                }
            }
            if ((bufferData = (Pair)((Tuple)cachedImages.get(textureName)).getSecond()) == null || bufferData.getSecond() == null || ((List)bufferData.getSecond()).isEmpty()) {
                return "";
            }
            if (textureName != null) {
                boolean shouldRepeat = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
                boolean doesContinue = (Integer)bufferData.getFirst() < ((List)bufferData.getSecond()).size() - 1;
                List resources = (List)((Tuple)cachedImages.get(textureName)).getThird();
                if ((Integer)bufferData.getFirst() < resources.size()) {
                    String texLocation = (String)resources.get((Integer)bufferData.getFirst());
                    if (((ImageFrame)((List)bufferData.getSecond()).get((Integer)bufferData.getFirst())).shouldRenderNext()) {
                        if (doesContinue) {
                            ((ImageFrame)((List)bufferData.getSecond()).get((Integer)bufferData.setFirst((Integer)bufferData.getFirst() + 1))).setRenderTime(System.currentTimeMillis());
                        } else if (shouldRepeat) {
                            ((ImageFrame)((List)bufferData.getSecond()).get((Integer)bufferData.setFirst(0))).setRenderTime(System.currentTimeMillis());
                        }
                    }
                    return texLocation;
                }
                return "";
            }
            return "";
        }
    }

    public static boolean isExternalImage(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.toLowerCase().startsWith("http") || (Boolean)StringUtils.isBase64(input).getFirst() != false || input.toLowerCase().startsWith("file://"));
    }

    public static byte[] decodeBase64(String input, String encoding, boolean useDecodingMethod, boolean repeatCycle) {
        try {
            return Base64.decodeBase64((String)(useDecodingMethod ? URLDecoder.decode(input, encoding) : input));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            if (!repeatCycle) {
                return ImageUtils.decodeBase64(input, encoding, !useDecodingMethod, true);
            }
            return null;
        }
    }

    public static boolean isTextureNull(String location) {
        return location == null || StringUtils.isNullOrEmpty(location);
    }

    static {
        urlQueue.start();
    }

    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

