/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.guava.ClassPath;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtils {
    private static final Gson GSON = new GsonBuilder().create();

    public static Object getJSONFromFile(File file, Class classObj) throws Exception {
        return FileUtils.getJSONFromFile(FileUtils.fileToString(file, "UTF-8"), classObj);
    }

    public static Object getJSONFromFile(String file, Class classObj) {
        return GSON.fromJson(file, classObj);
    }

    public static JsonObject parseJson(String json) {
        if (!StringUtils.isNullOrEmpty(json)) {
            JsonParser dataParser = new JsonParser();
            return dataParser.parse(json).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static void downloadFile(String urlString, File file) {
        try {
            boolean fileDeleted;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.init", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
            URL url = new URL(urlString);
            if (file.exists() && !(fileDeleted = file.delete())) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.delete.file", file.getName()), new Object[0]);
            }
            InputStream stream = UrlUtils.getURLStream(url);
            org.apache.commons.io.FileUtils.copyInputStreamToFile(stream, file);
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.loaded", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.download", file.getName(), urlString, file.getAbsolutePath()), new Object[0]);
            ex.printStackTrace();
        }
    }

    public static void loadFileAsDLL(File file) {
        try {
            boolean isPermsSet;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.init", file.getName()), new Object[0]);
            boolean bl = isPermsSet = file.setReadable(true) && file.setWritable(true);
            if (isPermsSet) {
                System.load(file.getAbsolutePath());
            }
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.loaded", file.getName()), new Object[0]);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.dll", file.getName()), new Object[0]);
            ex.printStackTrace();
        }
    }

    public static String fileToString(File file, String encoding) throws Exception {
        return org.apache.commons.io.FileUtils.readFileToString(file, Charset.forName(encoding));
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static int getModCount() {
        int modCount = ModUtils.IS_DEV ? 1 : 0;
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getClassNamesMatchingSuperType(List searchList, boolean includeExtraClasses, String ... sourcePackages) {
        ArrayList matchingClasses = Lists.newArrayList();
        ArrayList classList = Lists.newArrayList();
        ArrayList sourceData = Lists.newArrayList((Object[])sourcePackages);
        if (includeExtraClasses) {
            sourceData.addAll(FileUtils.getModClassNames());
        }
        try {
            classList.addAll(ClassPath.from(ModUtils.CLASS_LOADER).getAllClasses());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String startString : sourceData) {
            boolean found = false;
            Class loadedInstance = null;
            try {
                for (ClassPath.ClassInfo classInfo : classList) {
                    if (!classInfo.getName().startsWith(startString)) continue;
                    found = true;
                    loadedInstance = classInfo.load();
                }
                if (found || !includeExtraClasses) continue;
                Class extraClass = Class.forName(startString, false, ModUtils.CLASS_LOADER);
                found = true;
                loadedInstance = extraClass;
            }
            catch (Error | Exception ex) {
                if (!ModUtils.IS_VERBOSE) continue;
                ex.printStackTrace();
            }
            finally {
                if (!found || loadedInstance == null) continue;
                Pair subClassData = new Pair(false, Lists.newArrayList());
                for (Class searchClass : searchList) {
                    subClassData = FileUtils.isSubclassOf(loadedInstance, searchClass, (List)subClassData.getSecond());
                    if (((Boolean)subClassData.getFirst()).booleanValue()) {
                        matchingClasses.add(loadedInstance);
                        matchingClasses.addAll((Collection)subClassData.getSecond());
                        break;
                    }
                    subClassData = new Pair(false, Lists.newArrayList());
                }
            }
        }
        return matchingClasses;
    }

    protected static Pair isSubclassOf(Class originalClass, Class superClass, List scannedClasses) {
        Class clazz = originalClass;
        if (superClass.equals(Object.class)) {
            return new Pair(true, scannedClasses);
        }
        if (clazz.equals(superClass)) {
            return new Pair(true, scannedClasses);
        }
        if ((clazz = clazz.getSuperclass()) == null || clazz.equals(Object.class)) {
            return new Pair(false, scannedClasses);
        }
        scannedClasses.add(clazz);
        return FileUtils.isSubclassOf(clazz, superClass, scannedClasses);
    }

    public static List getClassNamesMatchingSuperType(Class searchTarget, boolean includeExtraClasses, String ... sourcePackages) {
        return FileUtils.getClassNamesMatchingSuperType(Lists.newArrayList((Object[])new Class[]{searchTarget}), includeExtraClasses, sourcePackages);
    }

    public static List getModClassNames() {
        ArrayList classNames = Lists.newArrayList();
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                try {
                    JarFile jarFile = new JarFile(modFile.getAbsolutePath());
                    Enumeration<JarEntry> allEntries = jarFile.entries();
                    while (allEntries.hasMoreElements()) {
                        JarEntry entry = allEntries.nextElement();
                        String file = entry.getName();
                        if (!file.endsWith(".class")) continue;
                        String className = file.replace('/', '.').substring(0, file.length() - 6);
                        classNames.add(className);
                    }
                    jarFile.close();
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) continue;
                    ex.printStackTrace();
                }
            }
            return classNames;
        }
        return Lists.newArrayList();
    }

    public static InputStream getResourceAsStream(Class fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = ModUtils.CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }
}

