/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.impl.guava;

import com.gitlab.cdagaming.craftpresence.impl.guava.CollectPreconditions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class MultimapBuilder {
    private static final int DEFAULT_EXPECTED_KEYS = 8;

    private MultimapBuilder() {
    }

    public static MultimapBuilderWithKeys hashKeys() {
        return MultimapBuilder.hashKeys(8);
    }

    public static MultimapBuilderWithKeys hashKeys(final int expectedKeys) {
        CollectPreconditions.checkNonnegative(expectedKeys, "expectedKeys");
        return new MultimapBuilderWithKeys(){

            @Override
            Map createMap() {
                return Maps.newHashMapWithExpectedSize((int)expectedKeys);
            }
        };
    }

    public static MultimapBuilderWithKeys linkedHashKeys() {
        return MultimapBuilder.linkedHashKeys(8);
    }

    public static MultimapBuilderWithKeys linkedHashKeys(final int expectedKeys) {
        CollectPreconditions.checkNonnegative(expectedKeys, "expectedKeys");
        return new MultimapBuilderWithKeys(){

            @Override
            Map createMap() {
                return new LinkedHashMap(expectedKeys);
            }
        };
    }

    public static MultimapBuilderWithKeys treeKeys() {
        return MultimapBuilder.treeKeys((Comparator)Ordering.natural());
    }

    public static MultimapBuilderWithKeys treeKeys(final Comparator comparator) {
        Preconditions.checkNotNull((Object)comparator);
        return new MultimapBuilderWithKeys(){

            @Override
            Map createMap() {
                return new TreeMap(comparator);
            }
        };
    }

    public static MultimapBuilderWithKeys enumKeys(final Class keyClass) {
        Preconditions.checkNotNull((Object)keyClass);
        return new MultimapBuilderWithKeys(){

            @Override
            Map createMap() {
                return new EnumMap(keyClass);
            }
        };
    }

    public abstract Multimap build();

    public Multimap build(Multimap multimap) {
        Multimap result = this.build();
        result.putAll(multimap);
        return result;
    }

    public static abstract class SortedSetMultimapBuilder
    extends SetMultimapBuilder {
        SortedSetMultimapBuilder() {
        }

        public abstract SortedSetMultimap build();

        public SortedSetMultimap build(Multimap multimap) {
            return (SortedSetMultimap)super.build(multimap);
        }
    }

    public static abstract class SetMultimapBuilder
    extends MultimapBuilder {
        SetMultimapBuilder() {
        }

        public abstract SetMultimap build();

        public SetMultimap build(Multimap multimap) {
            return (SetMultimap)super.build(multimap);
        }
    }

    public static abstract class ListMultimapBuilder
    extends MultimapBuilder {
        ListMultimapBuilder() {
        }

        public abstract ListMultimap build();

        public ListMultimap build(Multimap multimap) {
            return (ListMultimap)super.build(multimap);
        }
    }

    public static abstract class MultimapBuilderWithKeys {
        private static final int DEFAULT_EXPECTED_VALUES_PER_KEY = 2;

        MultimapBuilderWithKeys() {
        }

        abstract Map createMap();

        public ListMultimapBuilder arrayListValues() {
            return this.arrayListValues(2);
        }

        public ListMultimapBuilder arrayListValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new ListMultimapBuilder(){

                @Override
                public ListMultimap build() {
                    return Multimaps.newListMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)new ArrayListSupplier(expectedValuesPerKey));
                }
            };
        }

        public ListMultimapBuilder linkedListValues() {
            return new ListMultimapBuilder(){

                @Override
                public ListMultimap build() {
                    return Multimaps.newListMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)LinkedListSupplier.instance());
                }
            };
        }

        public SetMultimapBuilder hashSetValues() {
            return this.hashSetValues(2);
        }

        public SetMultimapBuilder hashSetValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new SetMultimapBuilder(){

                @Override
                public SetMultimap build() {
                    return Multimaps.newSetMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)new HashSetSupplier(expectedValuesPerKey));
                }
            };
        }

        public SetMultimapBuilder linkedHashSetValues() {
            return this.linkedHashSetValues(2);
        }

        public SetMultimapBuilder linkedHashSetValues(final int expectedValuesPerKey) {
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new SetMultimapBuilder(){

                @Override
                public SetMultimap build() {
                    return Multimaps.newSetMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)new LinkedHashSetSupplier(expectedValuesPerKey));
                }
            };
        }

        public SortedSetMultimapBuilder treeSetValues() {
            return this.treeSetValues((Comparator)Ordering.natural());
        }

        public SortedSetMultimapBuilder treeSetValues(final Comparator comparator) {
            Preconditions.checkNotNull((Object)comparator, (Object)"comparator");
            return new SortedSetMultimapBuilder(){

                @Override
                public SortedSetMultimap build() {
                    return Multimaps.newSortedSetMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)new TreeSetSupplier(comparator));
                }
            };
        }

        public SetMultimapBuilder enumSetValues(final Class valueClass) {
            Preconditions.checkNotNull((Object)valueClass, (Object)"valueClass");
            return new SetMultimapBuilder(){

                @Override
                public SetMultimap build() {
                    EnumSetSupplier factory = new EnumSetSupplier(valueClass);
                    return Multimaps.newSetMultimap((Map)MultimapBuilderWithKeys.this.createMap(), (Supplier)factory);
                }
            };
        }
    }

    private static final class EnumSetSupplier
    implements Supplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class clazz;

        EnumSetSupplier(Class clazz) {
            this.clazz = (Class)Preconditions.checkNotNull((Object)clazz);
        }

        public Set get() {
            return EnumSet.noneOf(this.clazz);
        }
    }

    private static final class TreeSetSupplier
    implements Supplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator comparator;

        TreeSetSupplier(Comparator comparator) {
            this.comparator = (Comparator)Preconditions.checkNotNull((Object)comparator);
        }

        public SortedSet get() {
            return new TreeSet(this.comparator);
        }
    }

    private static final class LinkedHashSetSupplier
    implements Supplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int expectedValuesPerKey;

        LinkedHashSetSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
        }

        public Set get() {
            return Sets.newLinkedHashSetWithExpectedSize((int)this.expectedValuesPerKey);
        }
    }

    private static final class HashSetSupplier
    implements Supplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int expectedValuesPerKey;

        HashSetSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
        }

        public Set get() {
            return Sets.newHashSetWithExpectedSize((int)this.expectedValuesPerKey);
        }
    }

    private static final class ArrayListSupplier
    implements Supplier,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int expectedValuesPerKey;

        ArrayListSupplier(int expectedValuesPerKey) {
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
        }

        public List get() {
            return new ArrayList(this.expectedValuesPerKey);
        }
    }

    private static enum LinkedListSupplier implements Supplier
    {
        INSTANCE;


        public static Supplier instance() {
            LinkedListSupplier result = INSTANCE;
            return result;
        }

        public List get() {
            return new LinkedList();
        }
    }
}

