/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.logging.Logger;

public class ModLogger {
    private final String loggerName;
    private final Logger logInstance;

    ModLogger(String loggerName) {
        this.loggerName = loggerName;
        this.logInstance = Logger.getLogger(loggerName);
    }

    public void error(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((mp)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7c " + logMessage);
        } else {
            this.logInstance.severe(String.format(logMessage, logArguments));
        }
    }

    public void warn(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((mp)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r\u00a7e " + logMessage);
        } else {
            this.logInstance.warning(String.format(logMessage, logArguments));
        }
    }

    public void info(String logMessage, Object ... logArguments) {
        if (CraftPresence.player != null && !CraftPresence.CONFIG.hasChanged && !CraftPresence.closing && CraftPresence.CONFIG.showLoggingInChat) {
            StringUtils.sendMessageToPlayer((mp)CraftPresence.player, "\u00a76\u00a7l[\u00a7f\u00a7l" + this.loggerName + "\u00a76]\u00a7r " + logMessage);
        } else {
            this.logInstance.info(String.format(logMessage, logArguments));
        }
    }

    public void debugInfo(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.info("[Debug] " + logMessage, logArguments);
        }
    }

    public void debugWarn(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.warn("[Debug] " + logMessage, logArguments);
        }
    }

    public void debugError(String logMessage, Object ... logArguments) {
        if (ModUtils.IS_DEV) {
            this.error("[Debug] " + logMessage, logArguments);
        }
    }
}

