/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.util;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidStack;

public class Util {
    public static final int[] YAW = new int[]{0, 0, 180, 360, 90, 270};
    public static final int[] PITCH = new int[]{90, -90, 0, 0, 0, 0};
    public static final int[] SIDE_TO_FACE = new int[]{-1, -1, 2, 0, 1, 3};
    public static final int[] OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final Color[] MAP_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(89, 125, 39), new Color(109, 153, 48), new Color(127, 178, 56), new Color(109, 153, 48), new Color(174, 164, 115), new Color(213, 201, 140), new Color(247, 233, 163), new Color(213, 201, 140), new Color(117, 117, 117), new Color(144, 144, 144), new Color(167, 167, 167), new Color(144, 144, 144), new Color(180, 0, 0), new Color(220, 0, 0), new Color(255, 0, 0), new Color(220, 0, 0), new Color(112, 112, 180), new Color(138, 138, 220), new Color(160, 160, 255), new Color(138, 138, 220), new Color(117, 117, 117), new Color(144, 144, 144), new Color(167, 167, 167), new Color(144, 144, 144), new Color(0, 87, 0), new Color(0, 106, 0), new Color(0, 124, 0), new Color(0, 106, 0), new Color(180, 180, 180), new Color(220, 220, 220), new Color(255, 255, 255), new Color(220, 220, 220), new Color(115, 118, 129), new Color(141, 144, 158), new Color(164, 168, 184), new Color(141, 144, 158), new Color(129, 74, 33), new Color(157, 91, 40), new Color(183, 106, 47), new Color(157, 91, 40), new Color(79, 79, 79), new Color(96, 96, 96), new Color(112, 112, 112), new Color(96, 96, 96), new Color(45, 45, 180), new Color(55, 55, 220), new Color(64, 64, 255), new Color(55, 55, 220), new Color(73, 58, 35), new Color(89, 71, 43), new Color(104, 83, 50), new Color(89, 71, 43)};
    public static final TurtleSide[] TURTLE_SIDES = TurtleSide.values();
    private static NBTTagCompound e = null;

    public static Map arrayToMap(int[] array) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            ret.put(i + 1, array[i]);
        }
        return ret;
    }

    public static Map listToMap(List list) {
        HashMap ret = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ret.put(i + 1, list.get(i));
        }
        return ret;
    }

    public static Map iterableToMap(Iterable iterable) {
        HashMap ret = new HashMap();
        int i = 1;
        for (Object item : iterable) {
            ret.put(i++, item);
        }
        return ret;
    }

    public static Object getFirstElement(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Object getFirstElement(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            return array[i];
        }
        return null;
    }

    public static List merge(Collection ... collections) {
        int size = 0;
        for (Collection collection : collections) {
            size += collection.size();
        }
        ArrayList ret = new ArrayList(size);
        for (Collection collection : collections) {
            ret.addAll(collection);
        }
        return ret;
    }

    public static int[] getInventorySlots(IInventory inv, int side) {
        return inv instanceof net.minecraft.inventory.ISidedInventory ? ((net.minecraft.inventory.ISidedInventory)inv).func_94128_d(side) : (inv instanceof ISidedInventory ? Util.makeLegacySlotArray((ISidedInventory)inv, side) : Util.makeSlotArray(inv));
    }

    public static List buildInventorySlotWhitelist(IInventory inv) {
        ArrayList<Integer> ret = new ArrayList<Integer>(inv.func_70302_i_());
        if (inv instanceof net.minecraft.inventory.ISidedInventory) {
            net.minecraft.inventory.ISidedInventory sidedinv = (net.minecraft.inventory.ISidedInventory)inv;
            for (int i = 0; i < 6; ++i) {
                int[] slots = sidedinv.func_94128_d(i);
                for (int j = 0; j < slots.length; ++j) {
                    ret.add(j);
                }
            }
            if (inv instanceof TileEntityFurnace) {
                ret.remove(2);
            }
        } else {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ret.add(i);
            }
        }
        return ret;
    }

    public static AxisAlignedBB getAABB(ITurtleAccess turtle, int direction) {
        Vec3 pos = turtle.getPosition();
        return AxisAlignedBB.func_72332_a().func_72299_a(pos.field_72450_a - 0.5, pos.field_72448_b - 0.5, pos.field_72449_c - 0.5, pos.field_72450_a + 0.5 + 1.0 * (double)Facing.field_71586_b[direction], pos.field_72448_b + 0.5 + 1.0 * (double)Facing.field_71587_c[direction], pos.field_72449_c + 0.5 + 1.0 * (double)Facing.field_71585_d[direction]);
    }

    public static void storeOrDrop(ITurtleAccess turtle, ItemStack stack) {
        if (!turtle.storeItemStack(stack) && !turtle.dropItemStack(stack, OPPOSITE[turtle.getFacingDir()])) {
            turtle.dropItemStack(stack, turtle.getFacingDir());
        }
    }

    public static void storeOrDrop(TileInventory inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotstack = inv.func_70301_a(i);
            if (slotstack != null && !Util.areStacksEqual(slotstack, stack)) continue;
            int add = Math.min(stack.field_77994_a, slotstack == null ? Math.min(stack.func_77976_d(), inv.func_70297_j_()) : slotstack.func_77976_d() - slotstack.field_77994_a);
            if (slotstack == null) {
                slotstack = stack.func_77946_l();
            } else {
                slotstack.field_77994_a += add;
            }
            stack.field_77994_a -= add;
            inv.func_70299_a(i, slotstack);
            if (stack.field_77994_a > 0) continue;
            return;
        }
        int direction = 0;
        float xoff = inv.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71586_b[direction];
        float yoff = inv.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71587_c[direction];
        float zoff = inv.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71585_d[direction];
        EntityItem item = new EntityItem(inv.field_70331_k, (double)((float)inv.field_70329_l + xoff), (double)((float)inv.field_70330_m + yoff), (double)((float)inv.field_70327_n + zoff), stack);
        item.field_70293_c = 10;
        item.field_70159_w = (float)inv.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71586_b[direction];
        item.field_70181_x = (float)inv.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71587_c[direction];
        item.field_70179_y = (float)inv.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71585_d[direction];
        inv.field_70331_k.func_72838_d((Entity)item);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.field_77993_c == stack2.field_77993_c && (stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE || stack1.func_77984_f() && stack2.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static String camelCase(String in) {
        String s = "";
        String[] split = in.replace('_', ' ').split(" ");
        for (int i = 0; i < split.length; ++i) {
            s = i == 0 ? s + split[i].toLowerCase() : s + split[i].substring(0, 1).toUpperCase() + split[i].substring(1).toLowerCase();
        }
        return s;
    }

    public static String sanitize(String s, boolean allowColorCodes) {
        while (s.endsWith("\u00a7")) {
            s.substring(0, s.length() - 1);
        }
        if (!allowColorCodes) {
            s = s.replace('\u00a7', ' ').replace('\u0003', ' ').replace('\u0002', ' ').replace('\u001d', ' ').replace('\u001f', ' ').replace('\u0016', ' ');
        }
        s = s.replace('\n', ' ').replace('\r', ' ').replace('\b', ' ').replace('\f', ' ').replace("\t", "    ");
        return s;
    }

    public static int getXPFromLevel(int level) {
        return (int)(level <= 15 ? (double)(17 * level) : (level <= 30 ? 1.5 * (double)(level * level) - 29.5 * (double)level + 360.0 : 3.5 * (double)(level - level) - 151.5 * (double)level + 2220.0));
    }

    public static int getXPToAdvance(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public static int getLevelFromXP(int xp) {
        int level = 0;
        while (xp >= 0) {
            if ((xp -= Util.getXPToAdvance(level)) < 0) continue;
            ++level;
        }
        return level;
    }

    public static Object getPeripheral(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : TURTLE_SIDES) {
            IHostedPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return peripheral;
        }
        return null;
    }

    public static TurtleSide getPeripheralSide(ITurtleAccess turtle, Class clazz) {
        for (TurtleSide side : TURTLE_SIDES) {
            IHostedPeripheral peripheral = turtle.getPeripheral(side);
            if (peripheral == null || !clazz.isAssignableFrom(peripheral.getClass())) continue;
            return side;
        }
        return null;
    }

    public static int addFuel(ITurtleAccess turtle, int amount) {
        if (Integer.MAX_VALUE - amount <= turtle.getFuelLevel()) {
            int added = Integer.MAX_VALUE - turtle.getFuelLevel();
            turtle.consumeFuel(-added);
            return added;
        }
        turtle.consumeFuel(-amount);
        return amount;
    }

    public static boolean teleportTurtleTo(ITurtleAccess turtle, World world, int x, int y, int z) {
        Vec3 pos = turtle.getPosition();
        World prevWorld = turtle.getWorld();
        int id = prevWorld.func_72798_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
        int meta = prevWorld.func_72805_g((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
        world.func_72832_d(x, y, z, id, meta, 2);
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof ITurtleAccess)) {
            return false;
        }
        Reflector.setField(turtle, "m_moved", true);
        prevWorld.func_72832_d((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, 0, 0, 2);
        Reflector.invoke(te, "transferStateFrom", Object.class, turtle);
        prevWorld.func_72845_h((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
        world.func_72845_h(x, y, z);
        world.func_72851_f(x, y, z, id);
        prevWorld.func_72851_f((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, 0);
        return true;
    }

    public static boolean isPassthroughBlock(World world, int x, int y, int z) {
        if (y < 0 || y > 254) {
            return false;
        }
        int id = world.func_72798_a(x, y, z);
        return Block.field_71973_m[id] == null || Block.field_71973_m[id].isAirBlock(world, x, y, z) || Block.field_71973_m[id] instanceof BlockFluid || Block.field_71973_m[id] instanceof BlockSnow || Block.field_71973_m[id] instanceof BlockTallGrass;
    }

    public static void writeChunkCoordinatesToNBT(ChunkCoordinates coordinates, NBTTagCompound compound) {
        compound.func_74768_a("x", coordinates.field_71574_a);
        compound.func_74768_a("y", coordinates.field_71572_b);
        compound.func_74768_a("z", coordinates.field_71573_c);
    }

    public static ChunkCoordinates readChunkCoordinatesFromNBT(NBTTagCompound compound) {
        return new ChunkCoordinates(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
    }

    public static NBTTagList writeInventoryToNBT(IInventory inv) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        return list;
    }

    public static void readInventoryFromNBT(IInventory inv, NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = (NBTTagCompound)list.func_74743_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            inv.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
    }

    public static ForgeDirection getDirectionFromTurtleSide(TurtleSide side, int facing) {
        if (side == null) {
            return null;
        }
        switch (side) {
            case Left: {
                return ForgeDirection.getOrientation((int)facing).getRotation(ForgeDirection.WEST);
            }
            case Right: {
                return ForgeDirection.getOrientation((int)facing).getRotation(ForgeDirection.EAST);
            }
        }
        return null;
    }

    public static String join(String separator, Object[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + separator + array[i].toString();
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String join(String separator, Iterable iterable) {
        String ret = "";
        for (Object s : iterable) {
            ret = ret + separator + s.toString();
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String joinCC(String separator, Object[] array) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + separator + Util.camelCase(array[i].toString());
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static String joinCC(String separator, Iterable iterable) {
        String ret = "";
        for (Object s : iterable) {
            ret = ret + separator + Util.camelCase(s.toString());
        }
        return ret.isEmpty() ? "" : ret.substring(separator.length());
    }

    public static void setTurtleUpgrade(ITurtleAccess turtle, TurtleSide side, ITurtleUpgrade upgrade) {
        Reflector.invoke(turtle, "set" + side.name() + "Upgrade", Object.class, upgrade);
    }

    public static int[] makeSlotArray(IInventory inv) {
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static int[] makeLegacySlotArray(ISidedInventory inv, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int[] slots = new int[inv.getSizeInventorySide(dir)];
        int start = inv.getStartInventorySide(dir);
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = start + i;
        }
        return slots;
    }

    public static int getFuelValue(ItemStack stack) {
        return TileEntityFurnace.func_70398_a((ItemStack)stack);
    }

    public static ItemStack createItemStackNC(Object obj, int size, int meta) {
        if (obj != null) {
            if (obj instanceof Block) {
                return new ItemStack((Block)obj, size, meta);
            }
            if (obj instanceof Item) {
                return new ItemStack((Item)obj, size, meta);
            }
            if (obj instanceof Integer) {
                return new ItemStack(((Integer)obj).intValue(), size, meta);
            }
        }
        return null;
    }

    public static MovingObjectPosition rayTraceBlock(ITurtleAccess turtle, int direction) {
        Vec3 pos = turtle.getPosition();
        int x = (int)pos.field_72450_a + Facing.field_71586_b[direction];
        int y = (int)pos.field_72448_b + Facing.field_71587_c[direction];
        int z = (int)pos.field_72449_c + Facing.field_71585_d[direction];
        return new MovingObjectPosition(x, y, z, OPPOSITE[direction], Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    public static MovingObjectPosition rayTraceBlock(ITurtleAccess turtle) {
        return Util.rayTraceBlock(turtle, turtle.getFacingDir());
    }

    public static int getUUID(ItemStack stack) {
        return stack.func_77960_j() * 32768 + stack.field_77993_c ^ MiscPeripherals.instance.itemIDSeed;
    }

    public static ItemStack getUUID(int uuid) {
        return Util.getUUID(uuid, 1);
    }

    public static ItemStack getUUID(int uuid, int stackSize) {
        int meta = (int)Math.floor((uuid ^= MiscPeripherals.instance.itemIDSeed) / 32768);
        int id = uuid % 32768;
        return new ItemStack(id, stackSize, meta);
    }

    public static int getUUID(LiquidStack stack) {
        return Util.getUUID(new ItemStack(stack.itemID, stack.amount, stack.itemMeta));
    }

    public static MovingObjectPosition rayTrace(EntityLiving ent, double d) {
        double dd2;
        if (ent == null) {
            return null;
        }
        double d1 = d;
        float f = 1.0f;
        MovingObjectPosition mop = Util.rayTrace(ent, d, f);
        Vec3 vec3d = Util.getPosition((Entity)ent, f);
        if (mop != null) {
            d1 = mop.field_72307_f.func_72438_d(vec3d);
        }
        if (d1 > (dd2 = d)) {
            d1 = dd2;
        }
        d = d1;
        Vec3 vec3d1 = ent.func_70676_i(f);
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        Entity entity1 = null;
        float f1 = 1.0f;
        List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.field_70121_D.func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b((double)f1, (double)f1, (double)f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L()) continue;
            float f2 = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                entity1 = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            entity1 = entity;
            d2 = d3;
        }
        if (entity1 != null) {
            mop = new MovingObjectPosition(entity1);
        }
        return mop;
    }

    public static MovingObjectPosition rayTrace(EntityLiving ent, double par1, float par3) {
        Vec3 var4 = Util.getPosition((Entity)ent, par3);
        Vec3 var5 = ent.func_70676_i(par3);
        Vec3 var6 = var4.func_72441_c(var5.field_72450_a * par1, var5.field_72448_b * par1, var5.field_72449_c * par1);
        return ent.field_70170_p.func_72933_a(var4, var6);
    }

    public static Vec3 getPosition(Entity ent, float par1) {
        if (par1 == 1.0f) {
            return ent.field_70170_p.func_82732_R().func_72345_a(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        }
        double var2 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)par1;
        double var4 = ent.field_70167_r + (double)ent.func_70047_e() + (ent.field_70163_u - ent.field_70167_r) * (double)par1;
        double var6 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)par1;
        return ent.field_70170_p.func_82732_R().func_72345_a(var2, var4, var6);
    }
}

