/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import miscperipherals.api.ISmEntity;
import miscperipherals.api.ISmEntityFactory;
import miscperipherals.api.ISmNode;
import miscperipherals.api.ISmSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class SmallNetHelper
implements IPlayerTracker {
    private static final List usedUUIDs = new LinkedList();
    private static final Multimap binds = HashMultimap.create();
    private static final Map uuidCache = new WeakHashMap();

    public static UUID randomUUID() {
        UUID ret;
        while (usedUUIDs.contains(ret = UUID.randomUUID())) {
        }
        usedUUIDs.add(ret);
        return ret;
    }

    public static void setUUID(Entity entity, UUID uuid) {
        NBTTagCompound ourData;
        NBTTagCompound persisted;
        NBTTagCompound data = entity.getEntityData();
        if (data.func_74764_b("PlayerPersisted")) {
            persisted = data.func_74775_l("PlayerPersisted");
        } else {
            persisted = new NBTTagCompound();
            data.func_74782_a("PlayerPersisted", (NBTBase)persisted);
        }
        if (data.func_74764_b("MiscPeripherals")) {
            ourData = data.func_74775_l("MiscPeripherals");
        } else {
            ourData = new NBTTagCompound();
            persisted.func_74782_a("MiscPeripherals", (NBTBase)ourData);
        }
        if (ourData.func_74764_b("smNetLSB") && ourData.func_74764_b("smNetMSB")) {
            UUID oldUUID = new UUID(data.func_74763_f("smNetMSB"), data.func_74763_f("smNetLSB"));
            usedUUIDs.remove(oldUUID);
            uuidCache.remove(oldUUID);
        }
        ourData.func_74772_a("smNetLSB", uuid.getLeastSignificantBits());
        ourData.func_74772_a("smNetMSB", uuid.getMostSignificantBits());
        usedUUIDs.add(uuid);
        uuidCache.put(uuid, entity);
    }

    public static UUID getUUID(Entity entity) {
        UUID uuid = SmallNetHelper.getSavedUUID(entity);
        if (uuid == null) {
            uuid = SmallNetHelper.randomUUID();
            SmallNetHelper.setUUID(entity, uuid);
        }
        return uuid;
    }

    public static UUID getSavedUUID(Entity entity) {
        NBTTagCompound data = entity.getEntityData();
        if (data.func_74764_b("PlayerPersisted") && (data = data.func_74775_l("PlayerPersisted")).func_74764_b("MiscPeripherals") && (data = data.func_74775_l("MiscPeripherals")).func_74764_b("smNetLSB") && data.func_74764_b("smNetMSB")) {
            UUID uuid = new UUID(data.func_74763_f("smNetMSB"), data.func_74763_f("smNetLSB"));
            uuidCache.put(uuid, entity);
            usedUUIDs.add(uuid);
            return uuid;
        }
        return null;
    }

    public static void send(ISmSender from, UUID uuid, String type, String payload) {
        if (uuid == null) {
            throw new NullPointerException();
        }
        Entity ent = null;
        for (Map.Entry entry : uuidCache.entrySet()) {
            if (!uuid.equals(entry.getKey())) continue;
            ent = (Entity)entry.getValue();
            break;
        }
        if (ent == null) {
            return;
        }
        if (ent instanceof ISmEntity && SmallNetHelper.isInRange(from, (ISmEntity)ent)) {
            ((ISmEntity)ent).receive(from, type, payload);
        }
        for (Map.Entry entry : binds.entries()) {
            ISmEntity sment;
            if (!((Class)entry.getKey()).isAssignableFrom(ent.getClass()) || !SmallNetHelper.isInRange(from, sment = ((ISmEntityFactory)entry.getValue()).getEntity(ent))) continue;
            sment.receive(from, type, payload);
        }
    }

    public static boolean isInRange(ISmNode a, ISmNode b) {
        return a.getWorld() == b.getWorld() && a.getPosition().func_72438_d(b.getPosition()) < Math.max(a.getPower(), b.getPower());
    }

    public static void bindEntity(Class clazz, ISmEntityFactory factory) {
        binds.put((Object)clazz, (Object)factory);
    }

    public static void init() {
        new SmallNetHelper();
    }

    public SmallNetHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerPlayerTracker((IPlayerTracker)this);
    }

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        SmallNetHelper.getSavedUUID(event.entity);
    }

    public void onPlayerLogin(EntityPlayer player) {
        SmallNetHelper.getSavedUUID((Entity)player);
    }

    public void onPlayerLogout(EntityPlayer player) {
        uuidCache.remove(player);
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }
}

