/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.util;

import dan200.turtle.api.ITurtleAccess;
import miscperipherals.tile.Tile;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public interface Positionable {
    public Vec3 getPosition();

    public int getFacing();

    public World getWorld();

    public IInventory getInventory();

    public static class PositionableTurtle
    implements Positionable {
        private final ITurtleAccess turtle;

        public PositionableTurtle(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public Vec3 getPosition() {
            return this.turtle == null ? null : this.turtle.getVisualPosition(1.0f);
        }

        @Override
        public int getFacing() {
            return this.turtle.getFacingDir();
        }

        @Override
        public World getWorld() {
            return this.turtle == null ? null : this.turtle.getWorld();
        }

        @Override
        public IInventory getInventory() {
            return this.turtle instanceof IInventory ? (IInventory)this.turtle : null;
        }
    }

    public static class PositionableTile
    implements Positionable {
        private final TileEntity tile;

        public PositionableTile(TileEntity tile) {
            this.tile = tile;
        }

        @Override
        public Vec3 getPosition() {
            return this.tile == null ? null : Vec3.func_72443_a((double)this.tile.field_70329_l, (double)this.tile.field_70330_m, (double)this.tile.field_70327_n);
        }

        @Override
        public int getFacing() {
            return this.tile instanceof Tile ? (int)((Tile)this.tile).getFacing() : 0;
        }

        @Override
        public World getWorld() {
            return this.tile == null ? null : this.tile.field_70331_k;
        }

        @Override
        public IInventory getInventory() {
            return this.tile instanceof IInventory ? (IInventory)this.tile : null;
        }
    }
}

