/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.util;

import java.util.LinkedList;
import java.util.List;

public class BFMachine
implements Runnable {
    private String code;
    private String input;
    private List handlers = new LinkedList();
    public String output;
    private int pc = 0;
    private int head = 0;
    private int[] tape = new int[256];
    private int inputHead = -1;
    private int depth = 0;
    private int[] depthpos = new int[256];

    public BFMachine(String code) throws BFException {
        this.setCode(code);
    }

    public void setCode(String code) throws BFException {
        int open = 0;
        int close = 0;
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c == '[') {
                ++open;
                continue;
            }
            if (c != ']') continue;
            ++close;
        }
        if (open != close) {
            throw new BFException("parse error: unmatched brackets: " + open + " != " + close);
        }
        this.code = code;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void addEventHandler(BFEventHandler handler) {
        this.handlers.add(handler);
    }

    public boolean tick() throws BFException {
        if (this.pc >= this.code.length()) {
            for (BFEventHandler handler : this.handlers) {
                handler.onEnd(this.output);
            }
            return false;
        }
        char c = this.code.charAt(this.pc);
        switch (c) {
            case '>': {
                if (++this.head > this.tape.length) {
                    this.head = 0;
                }
                ++this.pc;
                break;
            }
            case '<': {
                if (--this.head < 0) {
                    this.head = this.tape.length - 1;
                }
                ++this.pc;
                break;
            }
            case '+': {
                int n = this.head;
                this.tape[n] = this.tape[n] + 1;
                ++this.pc;
                break;
            }
            case '-': {
                int n = this.head;
                this.tape[n] = this.tape[n] - 1;
                ++this.pc;
                break;
            }
            case '.': {
                for (BFEventHandler handler : this.handlers) {
                    handler.onOutput(this.output, "" + (char)this.tape[this.head]);
                }
                this.output = this.output + (char)this.tape[this.head];
                ++this.pc;
                break;
            }
            case ',': {
                if (this.input == null || ++this.inputHead >= this.input.length()) {
                    throw new BFException("at " + this.pc + ": reading beyond input size");
                }
                this.tape[this.head] = this.input.charAt(this.inputHead);
                ++this.pc;
                break;
            }
            case '[': {
                ++this.depth;
                if (this.depth >= this.depthpos.length) {
                    throw new BFException("at " + this.pc + ": code is too deep");
                }
                this.depthpos[this.depth] = this.pc++;
                if (this.tape[this.head] != 0) break;
                int j = 0;
                while (j < this.depth) {
                    ++this.pc;
                    if (this.code.charAt(this.pc) != ']') continue;
                    ++j;
                }
                ++this.pc;
                break;
            }
            case ']': {
                this.pc = this.tape[this.head] != 0 ? this.depthpos[this.depth] : ++this.pc;
                --this.depth;
                break;
            }
            case '$': {
                for (BFEventHandler handler : this.handlers) {
                    handler.onInsta(this.tape[this.head]);
                }
                ++this.pc;
                break;
            }
            default: {
                ++this.pc;
            }
        }
        return true;
    }

    @Override
    public void run() {
        try {
            while (this.tick()) {
            }
        }
        catch (BFException e) {
            for (BFEventHandler handler : this.handlers) {
                handler.onError(e);
            }
        }
    }

    public static interface BFEventHandler {
        public void onError(BFException var1);

        public void onInsta(int var1);

        public void onOutput(String var1, String var2);

        public void onEnd(String var1);
    }

    public static class BFException
    extends IllegalStateException {
        public BFException(String s) {
            super(s);
        }
    }
}

