/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.turtle.api.ITurtleAccess;
import java.util.Arrays;
import miscperipherals.upgrade.UpgradeTool;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.SlotStack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;

public abstract class UpgradeToolConsumable
extends UpgradeTool {
    protected ItemStack currentItem;

    @Override
    public boolean canAttack(ITurtleAccess turtle, Entity ent) {
        return super.canAttack(turtle, ent) && this.consumeItem(turtle, false);
    }

    @Override
    public boolean attack(ITurtleAccess turtle, Entity ent) {
        boolean ret = super.attack(turtle, ent);
        if (ret) {
            this.consumeItem(turtle, true);
        }
        return ret;
    }

    @Override
    public int getDamage(ITurtleAccess turtle, Entity ent) {
        SlotStack slotstack = this.findFirstConsumable(turtle);
        if (slotstack != null) {
            return slotstack.stack.func_77971_a(ent);
        }
        return 0;
    }

    @Override
    public boolean canDig(ITurtleAccess turtle, int x, int y, int z, int side) {
        int id;
        ItemStack item = this.getCraftingItem();
        if (item != null && Block.field_71973_m[id = turtle.getWorld().func_72798_a(x, y, z)] != null) {
            SlotStack slotstack = this.findFirstConsumable(turtle);
            if (slotstack != null) {
                return this.isToolEffective(slotstack.stack, id, turtle.getWorld().func_72805_g(x, y, z));
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean dig(ITurtleAccess turtle, int x, int y, int z, int side) {
        boolean ret = super.dig(turtle, x, y, z, side);
        if (ret) {
            this.consumeItem(turtle, true);
        }
        return ret;
    }

    protected boolean isToolEffective(ItemStack stack, int id, int meta) {
        return stack.func_77973_b().func_77641_a(Block.field_71973_m[id]);
    }

    public Iterable getConsumedItems() {
        return Arrays.asList(this.getCraftingItem());
    }

    public boolean consumeItem(ITurtleAccess turtle, boolean doConsume) {
        SlotStack slotstack = this.findFirstConsumable(turtle);
        if (slotstack != null) {
            if (doConsume) {
                FakePlayer player = FakePlayer.get(turtle.getWorld());
                player.alignToTurtle(turtle);
                slotstack.stack.func_77972_a(1, (EntityLiving)player);
                if (slotstack.stack.field_77994_a <= 0) {
                    slotstack.stack = null;
                }
                turtle.setSlotContents(slotstack.slot, slotstack.stack);
            }
            return true;
        }
        return false;
    }

    SlotStack findFirstConsumable(ITurtleAccess turtle) {
        Iterable consumedItems = this.getConsumedItems();
        for (int i = 0; i < turtle.getInventorySize(); ++i) {
            ItemStack slotstack = turtle.getSlotContents(i);
            if (slotstack == null) continue;
            for (ItemStack stack : consumedItems) {
                if (stack.field_77993_c != slotstack.field_77993_c) continue;
                this.currentItem = slotstack;
                return new SlotStack(this.currentItem, i);
            }
        }
        return null;
    }
}

