/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import java.util.ArrayList;
import miscperipherals.core.EventHandler;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class UpgradeTool
implements ITurtleUpgrade {
    public abstract int getUpgradeID();

    public abstract String getAdjective();

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public abstract ItemStack getCraftingItem();

    public boolean isSecret() {
        return false;
    }

    public abstract Icon getIcon(ITurtleAccess var1, TurtleSide var2);

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        World world = turtle.getWorld();
        switch (verb) {
            case Attack: {
                Vec3 pos = turtle.getPosition();
                FakePlayer player = FakePlayer.get(turtle);
                player.alignToTurtle(turtle, direction);
                player.setHeldItem(this.getCraftingItem());
                MovingObjectPosition mop = Util.rayTrace((EntityLiving)player, 1.5);
                if (mop == null || mop.field_72313_a != EnumMovingObjectType.ENTITY) {
                    return false;
                }
                if (!this.canAttack(turtle, mop.field_72308_g)) {
                    return false;
                }
                return this.attack(turtle, mop.field_72308_g);
            }
            case Dig: {
                MovingObjectPosition mop = Util.rayTraceBlock(turtle, direction);
                int id = world.func_72798_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                int meta = world.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (Block.field_71973_m[id] == null || world.func_72799_c(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                    return false;
                }
                if (!this.canDig(turtle, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, Util.OPPOSITE[direction])) {
                    return false;
                }
                for (ItemStack stack : this.getBlockDrops(turtle, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, Util.OPPOSITE[direction])) {
                    Util.storeOrDrop(turtle, stack);
                }
                return this.dig(turtle, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, Util.OPPOSITE[direction]);
            }
        }
        return false;
    }

    public boolean canAttack(ITurtleAccess turtle, Entity ent) {
        return true;
    }

    public boolean attack(final ITurtleAccess turtle, Entity ent) {
        EntityLiving living = null;
        if (ent instanceof EntityLiving) {
            living = (EntityLiving)ent;
        }
        if (living != null) {
            EventHandler.dropConsumers.put(living, new EventHandler.DropConsumer(){

                @Override
                public void onDrops(DamageSource source, ArrayList drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
                    for (EntityItem drop : drops) {
                        Util.storeOrDrop(turtle, drop.func_92059_d());
                    }
                    drops.clear();
                }
            });
        }
        boolean ret = ent.func_70097_a(DamageSource.func_76358_a((EntityLiving)new EntityLiving(turtle.getWorld()){

            public String func_70023_ak() {
                return "ComputerCraft";
            }

            public void func_70088_a() {
            }

            public void func_70037_a(NBTTagCompound var1) {
            }

            public void func_70014_b(NBTTagCompound var1) {
            }

            public int func_70667_aM() {
                return 0;
            }
        }), this.getDamage(turtle, ent));
        if (living != null && living.func_70630_aN() > 0) {
            EventHandler.dropConsumers.remove(living);
        }
        return ret;
    }

    public int getDamage(ITurtleAccess turtle, Entity ent) {
        return this.getCraftingItem().func_77971_a(ent);
    }

    public boolean canDig(ITurtleAccess turtle, int x, int y, int z, int side) {
        int id;
        ItemStack item = this.getCraftingItem();
        if (item != null && Block.field_71973_m[id = turtle.getWorld().func_72798_a(x, y, z)] != null) {
            return ForgeHooks.isToolEffective((ItemStack)item, (Block)Block.field_71973_m[id], (int)turtle.getWorld().func_72805_g(x, y, z));
        }
        return false;
    }

    public Iterable getBlockDrops(ITurtleAccess turtle, int x, int y, int z, int side) {
        World world = turtle.getWorld();
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (Block.field_71973_m[id] == null || !ForgeHooks.isToolEffective((ItemStack)this.getCraftingItem(), (Block)Block.field_71973_m[id], (int)meta)) {
            return new ArrayList(0);
        }
        return Block.field_71973_m[id].getBlockDropped(world, x, y, z, meta, 0);
    }

    public boolean dig(ITurtleAccess turtle, int x, int y, int z, int side) {
        World world = turtle.getWorld();
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        world.func_72926_e(2001, x, y, z, id + meta * Block.field_71973_m.length);
        world.func_72832_d(x, y, z, 0, 0, 2);
        return true;
    }
}

