/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Arrays;
import java.util.List;
import miscperipherals.api.IUpgradeToolIcons;
import miscperipherals.upgrade.UpgradeTool;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class UpgradeShears
extends UpgradeTool
implements IUpgradeToolIcons {
    private static final List SHEAR_DIG = Arrays.asList(Block.field_72101_ab, Block.field_71955_W);
    private Icon icon;

    @Override
    public int getUpgradeID() {
        return 230;
    }

    @Override
    public String getAdjective() {
        return "Shearing";
    }

    @Override
    public ItemStack getCraftingItem() {
        return new ItemStack((Item)Item.field_77745_be, 1, Short.MAX_VALUE);
    }

    @Override
    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.icon;
    }

    @Override
    public boolean canAttack(ITurtleAccess turtle, Entity ent) {
        return ent instanceof IShearable && ((IShearable)ent).isShearable(this.getCraftingItem(), ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v);
    }

    @Override
    public boolean attack(ITurtleAccess turtle, Entity ent) {
        for (ItemStack is : ((IShearable)ent).onSheared(this.getCraftingItem(), ent.field_70170_p, (int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v, 0)) {
            Util.storeOrDrop(turtle, is);
        }
        return true;
    }

    @Override
    public boolean canDig(ITurtleAccess turtle, int x, int y, int z, int side) {
        Block block = Block.field_71973_m[turtle.getWorld().func_72798_a(x, y, z)];
        return block instanceof IShearable || SHEAR_DIG.contains(block);
    }

    @Override
    public Iterable getBlockDrops(ITurtleAccess turtle, int x, int y, int z, int side) {
        World world = turtle.getWorld();
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        return SHEAR_DIG.contains(block) ? super.getBlockDrops(turtle, x, y, z, side) : ((IShearable)block).onSheared(this.getCraftingItem(), world, x, y, z, 0);
    }

    @Override
    public void registerIcons(IconRegister reg) {
        this.icon = reg.func_94245_a("shears");
    }
}

