/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import forestry.api.arboriculture.IToolGrafter;
import java.util.ArrayList;
import java.util.List;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.safe.Reflector;
import miscperipherals.upgrade.UpgradeToolConsumable;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.SlotStack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class UpgradeGrafter
extends UpgradeToolConsumable {
    private static final List GRAFTERS = new ArrayList(3);

    @Override
    public int getUpgradeID() {
        return 209;
    }

    @Override
    public String getAdjective() {
        return "Grafter";
    }

    @Override
    public ItemStack getCraftingItem() {
        try {
            return (ItemStack)GRAFTERS.get(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        try {
            return this.getCraftingItem().func_77954_c();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean canDig(ITurtleAccess turtle, int x, int y, int z, int side) {
        if (!this.consumeItem(turtle, false)) {
            return false;
        }
        Block block = Block.field_71973_m[turtle.getWorld().func_72798_a(x, y, z)];
        if (block != null) {
            return block.getClass().getName().equals("forestry.arboriculture.gadgets.BlockLeaves");
        }
        return false;
    }

    @Override
    public Iterable getBlockDrops(ITurtleAccess turtle, int x, int y, int z, int side) {
        World world = turtle.getWorld();
        FakePlayer player = FakePlayer.get(world);
        player.alignToTurtle(turtle);
        player.setHeldItem(this.currentItem);
        SlotStack slotstack = this.findFirstConsumable(turtle);
        if (slotstack == null || !(slotstack.stack.func_77973_b() instanceof IToolGrafter)) {
            return new ArrayList(0);
        }
        IToolGrafter grafter = (IToolGrafter)slotstack.stack.func_77973_b();
        return (ArrayList)Reflector.invoke(Block.field_71973_m[world.func_72798_a(x, y, z)], "getLeafDrop", ArrayList.class, world, x, y, z, world.func_72805_g(x, y, z), Float.valueOf(grafter.getSaplingModifier(player.func_70694_bm(), world, (EntityPlayer)player, x, y, z)));
    }

    @Override
    public Iterable getConsumedItems() {
        return GRAFTERS;
    }

    public static void registerGrafter(ItemStack stack) {
        if (stack != null) {
            GRAFTERS.add(stack);
        } else {
            StackTraceElement ste = new Exception().getStackTrace()[1];
            MiscPeripherals.log.warning(ste.getClassName() + ":" + ste.getLineNumber() + " attempted to register a null grafter!");
        }
    }
}

