/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.upgrade;

import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import miscperipherals.api.IUpgradeIcons;
import miscperipherals.peripheral.PeripheralAdvancedSolar;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.upgrade.UpgradeSolar;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class UpgradeAdvancedSolar
extends UpgradeSolar
implements IUpgradeIcons {
    public static final String[] NAME = new String[]{"Advanced", "Hybrid", "Ultimate Hybrid"};
    public static final int[] OUTPUT_DAY = new int[]{ReflectionStore.advGenDay == null ? 8 : ReflectionStore.advGenDay, ReflectionStore.hGenDay == null ? 64 : ReflectionStore.hGenDay, ReflectionStore.uhGenDay == null ? 512 : ReflectionStore.uhGenDay};
    public static final int[] OUTPUT_NIGHT = new int[]{ReflectionStore.advGenNight == null ? 1 : ReflectionStore.advGenNight, ReflectionStore.hGenNight == null ? 8 : ReflectionStore.hGenNight, ReflectionStore.uhGenNight == null ? 64 : ReflectionStore.uhGenNight};
    private final int type;
    private Icon[] icons = new Icon[3];

    public UpgradeAdvancedSolar(int type) {
        this.type = type;
    }

    @Override
    public int getUpgradeID() {
        return 236 + this.type;
    }

    @Override
    public String getAdjective() {
        return NAME[this.type] + " Solar";
    }

    @Override
    public ItemStack getCraftingItem() {
        return new ItemStack(ReflectionStore.blockAdvSolarPanel, 1, this.type);
    }

    @Override
    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.icons[this.type];
    }

    @Override
    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new PeripheralAdvancedSolar(turtle, side, this.type);
    }

    @Override
    public void registerIcons(IconRegister reg) {
        this.icons[0] = reg.func_94245_a("MiscPeripherals:solar_adv");
        this.icons[1] = reg.func_94245_a("MiscPeripherals:solar_h");
        this.icons[2] = reg.func_94245_a("MiscPeripherals:solar_uh");
    }
}

