/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.logging.Level;
import miscperipherals.api.IMinecartData;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.Tile;
import miscperipherals.tile.TileInteractiveSorter;
import net.minecraft.entity.ai.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileRailReader
extends Tile
implements IPeripheral {
    private static final int TICK_RATE = 5;
    private final Map computers = new WeakHashMap();
    private final Map carts = new WeakHashMap();
    private int ticker = new Random().nextInt(5);

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_70316_g() {
        if (++this.ticker > 5) {
            this.ticker = 0;
            double rangeSub = 0.125;
            List carts = this.field_70331_k.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l + rangeSub, (double)(this.field_70330_m + 1), (double)this.field_70327_n + rangeSub, (double)(this.field_70329_l + 1) - rangeSub, (double)(this.field_70330_m + 2) - rangeSub, (double)(this.field_70327_n + 1) - rangeSub));
            LinkedList<EntityMinecart> toRemove = new LinkedList<EntityMinecart>();
            for (EntityMinecart cart : this.carts.keySet()) {
                if (carts.contains(cart)) continue;
                toRemove.add(cart);
            }
            for (EntityMinecart cart : toRemove) {
                this.carts.remove(cart);
            }
            for (EntityMinecart cart : carts) {
                if (this.carts.containsKey(cart)) continue;
                this.carts.put(cart, true);
                String cartType = "unknown";
                Map cartData = null;
                for (IMinecartData handler : IMinecartData.handlers) {
                    try {
                        Map retData = handler.getMinecartData(cart);
                        if (retData == null) continue;
                        cartData = retData;
                        break;
                    }
                    catch (Throwable e) {
                        MiscPeripherals.log.log(Level.WARNING, "Error processing minecart data handler " + handler, e);
                    }
                }
                if (cartData != null) {
                    if (cartData.containsKey("__CART_TYPE__")) {
                        cartType = (String)cartData.get("__CART_TYPE__");
                        cartData.remove("__CART_TYPE__");
                    }
                    if (cart instanceof IInventory) {
                        cartData.put("inventory", TileInteractiveSorter.makeInventoryMap((IInventory)cart));
                    }
                }
                for (IComputerAccess computer : this.computers.keySet()) {
                    computer.queueEvent("minecart", new Object[]{cartType, cart.field_70157_k, cartData});
                }
            }
        }
    }

    public String getType() {
        return "railReader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    static {
        IMinecartData.handlers.add(new VanillaMinecartData());
    }

    public static class VanillaMinecartData
    implements IMinecartData {
        @Override
        public Map getMinecartData(EntityMinecart cart) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (cart.getClass() == EntityMinecartEmpty.class) {
                ret.put("__CART_TYPE__", "basic");
                ret.put("occupied", cart.field_70153_n != null);
                if (cart.field_70153_n != null) {
                    ret.put("username", cart.field_70153_n.func_70023_ak());
                }
            } else if (cart.getClass() == EntityMinecartChest.class) {
                ret.put("__CART_TYPE__", "storage");
            } else if (cart.getClass() == EntityMinecartFurnace.class) {
                ret.put("__CART_TYPE__", "furnace");
                NBTTagCompound workaround = new NBTTagCompound();
                cart.func_70109_d(workaround);
                ret.put("fuel", workaround.func_74762_e("Fuel"));
            } else if (cart.getClass() == EntityMinecartHopper.class) {
                ret.put("__CART_TYPE__", "hopper");
            } else if (cart.getClass() == EntityMinecartTNT.class) {
                ret.put("__CART_TYPE__", "tnt");
            } else if (cart.getClass() == EntityMinecartMobSpawner.class) {
                ret.put("__CART_TYPE__", "spawner");
            }
            return ret.containsKey("__CART_TYPE__") ? ret : null;
        }
    }
}

