/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.api.IInteractiveSorterOutput;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class TileInteractiveSorter
extends TileInventory
implements IPeripheral {
    private Map computers = new WeakHashMap();
    private ItemStack lastStack;
    private int direction = -1;
    private int amount = 0;
    private int activeTicks = 0;
    private boolean tcDone = false;

    public TileInteractiveSorter() {
        super(1);
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        if (compound.func_74764_b("lastStack")) {
            this.lastStack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lastStack"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        if (this.lastStack != null) {
            NBTTagCompound lastStackCompound = new NBTTagCompound();
            this.lastStack.func_77955_b(lastStackCompound);
            compound.func_74766_a("lastStack", lastStackCompound);
        }
    }

    public void func_70296_d() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack != this.lastStack) {
            this.lastStack = stack;
            for (IComputerAccess computer : this.computers.keySet()) {
                computer.queueEvent("isort_item", new Object[]{Util.getUUID(stack), stack.field_77994_a});
            }
        }
    }

    public String getType() {
        return "interactiveSorter";
    }

    public String[] getMethodNames() {
        return new String[]{"sort", "list", "extract", "getItem"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                while (this.direction != -1) {
                    Thread.sleep(10L);
                }
                ItemStack stack = this.func_70301_a(0);
                if (stack == null) {
                    return new Object[]{false};
                }
                this.amount = arguments.length > 1 ? (int)Math.floor((Double)arguments[1]) : stack.field_77994_a;
                if (this.amount < 1 || this.amount > stack.field_77994_a) {
                    return new Object[]{false};
                }
                this.direction = direction;
                return new Object[]{true};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                final int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Map call() {
                        TileEntity te = TileInteractiveSorter.this.field_70331_k.func_72796_p(TileInteractiveSorter.this.field_70329_l + Facing.field_71586_b[direction], TileInteractiveSorter.this.field_70330_m + Facing.field_71587_c[direction], TileInteractiveSorter.this.field_70327_n + Facing.field_71585_d[direction]);
                        if (!(te instanceof IInventory)) {
                            return null;
                        }
                        return TileInteractiveSorter.makeInventoryMap((IInventory)te);
                    }
                });
                return new Object[]{callback.get()};
            }
            case 2: {
                if (arguments.length < 3) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (!(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                final int direction = (int)Math.floor((Double)arguments[0]);
                if (direction < 0 || direction > 5) {
                    throw new Exception("bad direction " + direction + " (expected 0-5)");
                }
                final int uuid = (int)Math.floor((Double)arguments[1]);
                final int outDir = (int)Math.floor((Double)arguments[2]);
                if (outDir < 0 || outDir > 5) {
                    throw new Exception("bad output direction " + outDir + " (expected 0-5)");
                }
                int tamount = Integer.MIN_VALUE;
                if (arguments.length > 3) {
                    if (!(arguments[3] instanceof Double)) {
                        throw new Exception("bad argument #4 (expected number)");
                    }
                    tamount = Math.abs((int)Math.floor((Double)arguments[3]));
                }
                final int amount = tamount;
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Integer call() {
                        int i;
                        TileEntity te = TileInteractiveSorter.this.field_70331_k.func_72796_p(TileInteractiveSorter.this.field_70329_l + Facing.field_71586_b[direction], TileInteractiveSorter.this.field_70330_m + Facing.field_71587_c[direction], TileInteractiveSorter.this.field_70327_n + Facing.field_71585_d[direction]);
                        if (!(te instanceof IInventory)) {
                            return 0;
                        }
                        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                        int remain = amount;
                        IInventory inv = (IInventory)te;
                        for (i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack slotstack = inv.func_70301_a(i);
                            if (slotstack == null || Util.getUUID(slotstack) != uuid) continue;
                            int adding = Math.min(slotstack.field_77994_a, remain);
                            remain -= adding;
                            ItemStack output = slotstack.func_77946_l();
                            output.field_77994_a = adding;
                            stacks.add(output);
                            slotstack.field_77994_a -= adding;
                            if (slotstack.field_77994_a <= 0) {
                                slotstack = null;
                            }
                            inv.func_70299_a(i, slotstack);
                            if (remain <= 0) break;
                        }
                        for (i = 0; i < stacks.size(); ++i) {
                            TileInteractiveSorter.outputItem(TileInteractiveSorter.this, (ItemStack)stacks.get(i), outDir);
                        }
                        return amount - remain;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 5: {
                ItemStack stack = this.func_70301_a(0);
                if (stack == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(stack), stack.field_77994_a};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.activeTicks > 0) {
            if (--this.activeTicks <= 0) {
                this.setActive(false);
            } else {
                this.setActive(true);
            }
        }
        if (this.direction > -1) {
            ItemStack stack = this.func_70301_a(0);
            int oldSize = stack.field_77994_a;
            stack.field_77994_a = this.amount;
            TileInteractiveSorter.outputItem(this, stack, this.direction);
            stack.field_77994_a = oldSize - this.amount;
            if (stack.field_77994_a <= 0) {
                stack = null;
            }
            this.func_70299_a(0, stack);
            this.activeTicks = 10;
            this.direction = -1;
        }
    }

    @Override
    public int getGuiId() {
        return 2;
    }

    @Override
    public String func_70303_b() {
        return "Interactive Sorter";
    }

    public static void outputItem(TileEntity tile, ItemStack stack, int direction) {
        for (IInteractiveSorterOutput output : IInteractiveSorterOutput.handlers) {
            output.output(stack, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, direction);
            if (stack.field_77994_a > 0) continue;
            break;
        }
        if (stack.field_77994_a > 0) {
            float xoff = tile.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71586_b[direction];
            float yoff = tile.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71587_c[direction];
            float zoff = tile.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f + 0.5f * (float)Facing.field_71585_d[direction];
            EntityItem item = new EntityItem(tile.field_70331_k, (double)((float)tile.field_70329_l + xoff), (double)((float)tile.field_70330_m + yoff), (double)((float)tile.field_70327_n + zoff), stack.func_77946_l());
            item.field_70293_c = 10;
            item.field_70159_w = (float)tile.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71586_b[direction];
            item.field_70181_x = (float)tile.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71587_c[direction];
            item.field_70179_y = (float)tile.field_70331_k.field_73012_v.nextGaussian() * 0.05f + (float)Facing.field_71585_d[direction];
            tile.field_70331_k.func_72838_d((Entity)item);
            stack.field_77994_a = 0;
        }
    }

    public static Map makeInventoryMap(IInventory inv) {
        HashMap<Long, Integer> items = new HashMap<Long, Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotstack = inv.func_70301_a(i);
            if (slotstack == null) continue;
            long uuid = Util.getUUID(slotstack);
            if (items.containsKey(uuid)) {
                items.put(uuid, (Integer)items.get(uuid) + slotstack.field_77994_a);
                continue;
            }
            items.put(uuid, slotstack.field_77994_a);
        }
        return items;
    }

    static {
        IInteractiveSorterOutput.handlers.add(new InventoryInteractiveSorterOutput());
    }

    public static class InventoryInteractiveSorterOutput
    implements IInteractiveSorterOutput {
        @Override
        public void output(ItemStack stack, World world, int posX, int posY, int posZ, int direction) {
            TileEntity te = world.func_72796_p(posX + Facing.field_71586_b[direction], posY + Facing.field_71587_c[direction], posZ + Facing.field_71585_d[direction]);
            if (stack != null && te instanceof IInventory) {
                IInventory inv = (IInventory)te;
                int[] slots = Util.getInventorySlots(inv, Util.OPPOSITE[direction]);
                for (int i = 0; i < slots.length; ++i) {
                    ItemStack put;
                    int slot = slots[i];
                    ItemStack slotStack = inv.func_70301_a(slot);
                    if (slotStack == null) {
                        put = stack.func_77946_l();
                        put.field_77994_a = Math.min(stack.field_77994_a, inv.func_70297_j_());
                        inv.func_70299_a(slot, put);
                        stack.field_77994_a -= put.field_77994_a;
                        if (stack.field_77994_a > 0) continue;
                        break;
                    }
                    if (!Util.areStacksEqual(slotStack, stack)) continue;
                    put = slotStack.func_77946_l();
                    int toPut = Math.min(stack.field_77994_a, Math.min(slotStack.func_77976_d() - slotStack.field_77994_a, inv.func_70297_j_() - slotStack.field_77994_a));
                    put.field_77994_a += toPut;
                    inv.func_70299_a(slot, put);
                    stack.field_77994_a -= toPut;
                    if (stack.field_77994_a <= 0) break;
                }
            }
        }
    }
}

