/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.TickHandler;
import miscperipherals.tile.TileInventory;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileCrafter
extends TileInventory
implements IPeripheral {
    public InventoryCrafting craftingInv = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);

    public TileCrafter() {
        super(18);
    }

    @Override
    public int getGuiId() {
        return 1;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        Util.readInventoryFromNBT((IInventory)this.craftingInv, tag.func_74761_m("craft"));
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74782_a("craft", (NBTBase)Util.writeInventoryToNBT((IInventory)this.craftingInv));
    }

    public String getType() {
        return "crafter";
    }

    public String[] getMethodNames() {
        return new String[]{"setPattern", "craft", "list", "get"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                int i;
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                int[] slots = new int[Math.min(arguments.length, this.craftingInv.func_70302_i_())];
                for (i = 0; i < slots.length; ++i) {
                    if (arguments[i] != null && !(arguments[i] instanceof Double)) {
                        throw new Exception("bad argument #" + (i + 1) + " (expected number)");
                    }
                    slots[i] = arguments[i] == null ? -1 : (int)Math.floor((Double)arguments[i]) - 1;
                    if (slots[i] >= -1 && slots[i] < this.func_70302_i_()) continue;
                    throw new Exception("bad slot " + (slots[i] + 1) + " (expected 0-" + this.func_70302_i_() + ")");
                }
                for (i = 0; i < this.craftingInv.func_70302_i_(); ++i) {
                    ItemStack stack;
                    if (i >= slots.length || slots[i] < 0) {
                        this.craftingInv.func_70299_a(i, null);
                        continue;
                    }
                    if (this.func_70301_a(slots[i]) == null) {
                        stack = null;
                    } else {
                        stack = this.func_70301_a(slots[i]).func_77946_l();
                        stack.field_77994_a = 1;
                        if (stack.func_77951_h()) {
                            stack.func_77964_b(0);
                        }
                    }
                    this.craftingInv.func_70299_a(i, stack);
                }
                return new Object[]{true};
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int slot = (int)Math.floor((Double)arguments[0]);
                ItemStack slotstack = this.func_70301_a(slot);
                ItemStack craftResult = this.craft(slotstack);
                if (craftResult == null) {
                    return new Object[]{false};
                }
                if (slotstack == null) {
                    slotstack = craftResult.func_77946_l();
                } else {
                    slotstack.field_77994_a += craftResult.field_77994_a;
                }
                this.func_70299_a(slot, slotstack);
                return new Object[]{true};
            }
            case 2: {
                Future callback = TickHandler.addTickCallback(this.field_70331_k, new Callable(){

                    public Map call() {
                        HashMap<Long, Integer> items = new HashMap<Long, Integer>();
                        for (int i = 0; i < TileCrafter.this.func_70302_i_(); ++i) {
                            ItemStack slotstack = TileCrafter.this.func_70301_a(i);
                            if (slotstack == null) continue;
                            long uuid = Util.getUUID(slotstack);
                            if (items.containsKey(uuid)) {
                                items.put(uuid, (Integer)items.get(uuid) + slotstack.field_77994_a);
                                continue;
                            }
                            items.put(uuid, slotstack.field_77994_a);
                        }
                        return items;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 3: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int slot = (int)Math.floor((Double)arguments[0]);
                if (slot < 0 || slot >= this.func_70302_i_()) {
                    throw new Exception("bad slot " + slot + " (expected 0-" + this.func_70302_i_() + ")");
                }
                ItemStack slotstack = this.func_70301_a(slot);
                if (slotstack == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(slotstack), slotstack.field_77994_a};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public String func_70303_b() {
        return "Computer Controlled Crafter";
    }

    public ItemStack craft(ItemStack slotstack) {
        int[] sizes = new int[this.func_70302_i_()];
        for (int i = 0; i < sizes.length; ++i) {
            ItemStack stack = this.func_70301_a(i);
            sizes[i] = stack == null ? 0 : stack.field_77994_a;
        }
        int[] remap = new int[this.craftingInv.func_70302_i_()];
        for (int i = 0; i < remap.length; ++i) {
            if (this.craftingInv.func_70301_a(i) == null) {
                remap[i] = -1;
                continue;
            }
            int pick = -1;
            for (int j = 0; j < sizes.length; ++j) {
                if (sizes[j] <= 0 || !Util.areStacksEqual(this.craftingInv.func_70301_a(i), this.func_70301_a(j))) continue;
                int n = j;
                sizes[n] = sizes[n] - 1;
                pick = j;
                break;
            }
            if (pick < 0) {
                return null;
            }
            remap[i] = pick;
        }
        InventoryCraftingMap ci = new InventoryCraftingMap((IInventory)this, remap);
        ItemStack craftResult = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)ci, this.field_70331_k);
        if (craftResult == null) {
            return null;
        }
        if (!(slotstack == null || Util.areStacksEqual(slotstack, craftResult) && slotstack.field_77994_a + craftResult.field_77994_a <= slotstack.func_77976_d())) {
            return null;
        }
        FakePlayer player = FakePlayer.get((Object)this);
        player.alignToTile(this);
        player.alignToInventory((IInventory)this);
        for (int i = 0; i < ci.func_70302_i_(); ++i) {
            ItemStack stack = ci.func_70301_a(i);
            if (stack == null) continue;
            ci.func_70298_a(i, 1);
            if (!stack.func_77973_b().func_77634_r()) continue;
            ItemStack container = stack.func_77973_b().getContainerItemStack(stack);
            if (container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((EntityPlayer)player, container));
                container = null;
            }
            if (container == null) continue;
            if (this.func_70301_a(i) == null) {
                this.func_70299_a(i, container);
                continue;
            }
            Util.storeOrDrop(this, container);
        }
        return craftResult;
    }

    public static class InventoryCraftingMap
    extends InventoryCrafting {
        private IInventory inv;
        private int[] remap;

        public InventoryCraftingMap(IInventory inv, int[] remap) {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer var1) {
                    return false;
                }
            }, (int)Math.sqrt(remap.length), (int)Math.sqrt(remap.length));
            this.inv = inv;
            this.remap = remap;
        }

        public ItemStack func_70301_a(int par1) {
            return this.remap[par1] >= 0 ? this.inv.func_70301_a(this.remap[par1]) : null;
        }

        public ItemStack func_70298_a(int par1, int par2) {
            return this.remap[par1] >= 0 ? this.inv.func_70298_a(this.remap[par1], par2) : null;
        }

        public void func_70299_a(int par1, ItemStack par2ItemStack) {
            if (this.remap[par1] >= 0) {
                this.inv.func_70299_a(this.remap[par1], par2ItemStack);
            }
        }

        public int func_70297_j_() {
            return this.inv.func_70297_j_();
        }
    }
}

