/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.tile;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.network.NetworkHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public class Tile
extends TileEntity
implements IEntityAdditionalSpawnData {
    protected boolean loaded = false;
    private boolean active = false;
    private int facing = 4;

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.loaded) {
            if (!this.func_70320_p() && this.field_70331_k != null) {
                this.onLoaded();
            } else {
                System.out.println((Object)((Object)this) + " (" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ") was not added due to a null world! This should never happen!");
            }
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.facing = tag.func_74771_c("facing");
        this.active = tag.func_74767_n("active");
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("facing", (byte)this.facing);
        tag.func_74757_a("active", this.active);
    }

    public Packet func_70319_e() {
        return NetworkHelper.getTileInfoPacket(this);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeByte(this.facing);
        data.writeBoolean(this.active);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.setFacing(data.readByte());
        this.setActive(data.readBoolean());
    }

    public void onLoaded() {
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setFacing(int facing) {
        if (this.facing != facing) {
            this.facing = facing;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public short getFacing() {
        return (short)this.facing;
    }

    public int getGuiId() {
        return -1;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int id = this.getGuiId();
        if (id < 0) {
            return false;
        }
        player.openGui((Object)MiscPeripherals.instance, id, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public int getRedstone() {
        return this.field_70331_k == null ? 0 : this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int getComparator(int side) {
        return 0;
    }
}

