/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.speech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.TickHandlerClient;
import miscperipherals.speech.ISpeechProvider;
import miscperipherals.speech.SpeechManager;
import net.minecraft.client.audio.SoundManager;

@SideOnly(value=Side.CLIENT)
public class ThreadSpeechProvider
extends Thread {
    public final String text;
    public final double speed;
    public final double x;
    public final double y;
    public final double z;
    private boolean locked = false;
    public File file;
    public String source;

    public ThreadSpeechProvider(String text, double speed, double x, double y, double z) {
        super("MiscPeripherals Speech Provider");
        this.text = text;
        this.speed = speed;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void run() {
        if (SpeechManager.preferred != null && SpeechManager.preferred.canUse(this.text, this.x, this.y, this.z, this.speed)) {
            this.file = SpeechManager.preferred.speak(this.text, this.speed);
        }
        if (this.file == null) {
            for (ISpeechProvider provider : SpeechManager.providers) {
                if (!provider.canUse(this.text, this.speed, this.x, this.y, this.z)) continue;
                this.file = provider.speak(this.text, this.speed);
                if (this.file == null) continue;
                if (!this.file.exists()) {
                    MiscPeripherals.log.warning("Speech provider '" + provider.getName() + "' provided a non-existant file!");
                    continue;
                }
                break;
            }
        } else if (!this.file.exists() && SpeechManager.preferred != null) {
            MiscPeripherals.log.warning("Preferred speech provider '" + SpeechManager.preferred.getName() + "' provided a non-existant file!");
        }
        if (this.file == null) {
            return;
        }
        this.source = this.file.getName();
        TickHandlerClient.addSpeech(this);
        try {
            this.locked = true;
            while (this.locked) {
                Thread.sleep(100L);
            }
        }
        catch (Throwable e) {
            if (!this.file.delete()) {
                MiscPeripherals.log.warning("Could not delete temporary speech file " + this.file.getName());
            }
            return;
        }
        try {
            while (SoundManager.field_77381_a.playing(this.source)) {
                Thread.sleep(250L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!this.file.delete()) {
            MiscPeripherals.log.warning("Could not delete temporary speech file " + this.file.getName());
        }
    }

    public void unlock() {
        this.locked = false;
    }
}

