/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.speech;

import com.jacob.com.Dispatch;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import miscperipherals.speech.ISpeechProvider;
import miscperipherals.speech.SpeechManager;

@SideOnly(value=Side.CLIENT)
public class SpeechProviderWindows
implements ISpeechProvider {
    public static final int SAPI_FILE_TYPE = 35;
    public static final boolean DEBUG = false;
    private Dispatch voice = new Dispatch("SAPI.SpVoice");
    private Dispatch format = new Dispatch("SAPI.SpAudioFormat");
    private Dispatch stream;

    public SpeechProviderWindows() {
        Dispatch.put(this.format, "Type", (Object)35);
        this.stream = new Dispatch("SAPI.SpFileStream");
        Dispatch.putRef(this.stream, "Format", (Object)this.format);
        Runtime.getRuntime().addShutdownHook(new Thread("MiscPeripherals Speech Release"){

            @Override
            public void run() {
                SpeechProviderWindows.this.voice.safeRelease();
                SpeechProviderWindows.this.format.safeRelease();
                SpeechProviderWindows.this.stream.safeRelease();
            }
        });
    }

    @Override
    public String getName() {
        return "windows";
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean canUse(String text, double speed, double x, double y, double z) {
        return true;
    }

    @Override
    public synchronized File speak(String text, double speed) {
        try {
            File f = SpeechManager.makeTempFile(".wav");
            int rate = (int)((float)speed * 10.0f);
            if (rate < -10) {
                rate = -10;
            } else if (rate > 10) {
                rate = 10;
            }
            Dispatch.put(this.voice, "Rate", (Object)speed);
            Dispatch.call(this.stream, "Open", f.getPath(), 3, false);
            Dispatch.putRef(this.voice, "AudioOutputStream", (Object)this.stream);
            Dispatch.call(this.voice, "Speak", text);
            Dispatch.call(this.stream, "Close");
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

