/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import codechicken.core.Vector3;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.safe.Reflector;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralWirelessRedstone
implements IHostedPeripheral,
WirelessReceivingDevice,
WirelessTransmittingDevice {
    private final ITurtleAccess turtle;
    private final Map computers = new WeakHashMap();
    private int frequency = 0;
    private boolean state = false;
    private WeakReference worldCache;
    private boolean skipOn = false;

    public PeripheralWirelessRedstone(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "wirelessRedstone";
    }

    public String[] getMethodNames() {
        return new String[]{"setFreq", "setFrequency", "get", "set", "getFreq", "getFrequency"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        this.updateWorld();
        switch (method) {
            case 0: 
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                final Object rether = this.getRether();
                final int freq = (int)Math.floor((Double)arguments[0]);
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        PeripheralWirelessRedstone.this.skipOn = true;
                        Reflector.invoke(rether, "removeReceivingDevice", Object.class, PeripheralWirelessRedstone.this);
                        Reflector.invoke(rether, "removeTransmittingDevice", Object.class, PeripheralWirelessRedstone.this);
                        PeripheralWirelessRedstone.this.frequency = freq;
                        Reflector.invoke(rether, "addReceivingDevice", Object.class, PeripheralWirelessRedstone.this);
                        PeripheralWirelessRedstone.this.skipOn = false;
                        return null;
                    }
                });
                callback.get();
                return new Object[]{true};
            }
            case 2: {
                return new Object[]{this.state};
            }
            case 3: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new Exception("bad argument #1 (expected boolean)");
                }
                final boolean state = (Boolean)arguments[0];
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        PeripheralWirelessRedstone.this.skipOn = true;
                        Reflector.invoke(PeripheralWirelessRedstone.this.getRether(), state ? "addTransmittingDevice" : "removeTransmittingDevice", Object.class, PeripheralWirelessRedstone.this);
                        PeripheralWirelessRedstone.this.skipOn = false;
                        return null;
                    }
                });
                callback.get();
            }
            case 4: 
            case 5: {
                return new Object[]{this.frequency};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.updateWorld();
        this.computers.put(computer, true);
        Reflector.invoke(this.getRether(), "addReceivingDevice", Object.class, this);
    }

    public void detach(IComputerAccess computer) {
        this.updateWorld();
        this.computers.remove(computer);
        Object rether = this.getRether();
        Reflector.invoke(rether, "removeReceivingDevice", Object.class, this);
        Reflector.invoke(rether, "removeTransmittingDevice", Object.class, this);
    }

    public void update() {
    }

    public Vector3 getPosition() {
        Vec3 pos = this.turtle.getPosition();
        return new Vector3(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public int getDimension() {
        this.updateWorld();
        if (this.worldCache.get() == null) {
            return 0;
        }
        return ((World)this.worldCache.get()).field_73011_w.field_76574_g;
    }

    public int getFreq() {
        return this.frequency;
    }

    public EntityLiving getAttachedEntity() {
        return null;
    }

    public void updateDevice(int freq, boolean on) {
        if (freq == this.frequency && !this.skipOn) {
            this.state = on;
            for (IComputerAccess computer : this.computers.keySet()) {
                computer.queueEvent("wireless_redstone", new Object[]{freq, on});
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.frequency = nbttagcompound.func_74762_e("frequency");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("frequency", this.frequency);
    }

    private Object getRether() {
        return Reflector.invoke("codechicken.wirelessredstone.core.RedstoneEther", "server", Object.class, new Object[0]);
    }

    private void updateWorld() {
        if (this.worldCache == null || this.worldCache.get() == null) {
            try {
                this.worldCache = new WeakReference<World>(this.turtle.getWorld());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

