/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.HashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.util.SlotStack;
import miscperipherals.util.Util;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.tools.ToolCore;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PeripheralToolBuilder
implements IHostedPeripheral {
    public final ITurtleAccess turtle;

    public PeripheralToolBuilder(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "toolStation";
    }

    public String[] getMethodNames() {
        return new String[]{"build", "buildLast", "read"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: {
                ItemStack result;
                String name;
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (arguments[0] != null && !(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (arguments[1] != null && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments[2] != null && !(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof String)) {
                    throw new Exception("bad argument #4 (expected string)");
                }
                SlotStack[] stacks = new SlotStack[3];
                for (int i = 0; i < stacks.length; ++i) {
                    int slot;
                    int n = slot = arguments[i] != null ? (int)Math.floor((Double)arguments[i]) - 1 : -1;
                    if (slot < -1 || slot >= this.turtle.getInventorySize()) {
                        throw new Exception("bad slot " + (slot + 1) + " (expected 0-" + this.turtle.getInventorySize() + ")");
                    }
                    if (slot == -1) continue;
                    stacks[i] = new SlotStack(this.turtle.getSlotContents(slot), slot);
                }
                String string = name = arguments.length > 3 ? (String)arguments[3] : null;
                if (name != null && name.length() > 32) {
                    name = name.substring(0, 32);
                }
                if ((result = ToolBuilder.instance.buildTool(stacks[0] != null ? stacks[0].stack : null, stacks[1] != null ? stacks[1].stack : null, stacks[2] != null ? stacks[2].stack : null, name)) != null) {
                    int slot;
                    for (int i = 0; i < stacks.length; ++i) {
                        SlotStack stack = stacks[i];
                        if (stack == null || stack.stack == null) continue;
                        if (--stack.stack.field_77994_a <= 0) {
                            stack.stack = null;
                        }
                        this.turtle.setSlotContents(stack.slot, stack.stack);
                    }
                    int n = slot = method == 0 ? stacks[0].slot : stacks[stacks.length - 1].slot;
                    if (this.turtle.getSlotContents(slot) != null) {
                        Util.storeOrDrop(this.turtle, result);
                    } else {
                        this.turtle.setSlotContents(slot, result);
                    }
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 2: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int slot = (int)Math.floor((Double)arguments[0]) - 1;
                if (slot < 0 || slot > this.turtle.getInventorySize()) {
                    throw new Exception("bad slot " + (slot + 1) + " (expected 1-" + this.turtle.getInventorySize() + ")");
                }
                ItemStack stack = this.turtle.getSlotContents(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ToolCore) || stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("InfiTool")) {
                    return new Object[]{null};
                }
                NBTTagCompound data = stack.field_77990_d.func_74775_l("InfiTool");
                HashMap<String, Comparable<Boolean>> ret = new HashMap<String, Comparable<Boolean>>();
                ret.put("broken", Boolean.valueOf(data.func_74767_n("Broken")));
                ret.put("attack", Float.valueOf((float)data.func_74762_e("Attack") / 2.0f));
                ret.put("durabilityBase", Integer.valueOf(data.func_74762_e("BaseDurability")));
                ret.put("durabilityBonus", Integer.valueOf(data.func_74762_e("BonusDurability")));
                ret.put("durabilityMod", Float.valueOf(data.func_74760_g("ModDurability")));
                ret.put("durability", Integer.valueOf(data.func_74762_e("TotalDurability")));
                ret.put("damage", Float.valueOf((float)data.func_74762_e("Damage") / (float)data.func_74762_e("TotalDurability")));
                ret.put("shoddy", Integer.valueOf((int)Math.floor(data.func_74760_g("Shoddy"))));
                ret.put("reinforced", Integer.valueOf(data.func_74762_e("Unbreaking")));
                ret.put("speed", Integer.valueOf(data.func_74762_e("MiningSpeed") / 100));
                return new Object[]{ret};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

