/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.TickHandler;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class PeripheralTank
implements IHostedPeripheral,
ILiquidTank {
    public static final int CAPACITY = 10000;
    public static final int TICK_RATE = 20;
    private final ITurtleAccess turtle;
    public LiquidStack liquid;
    private LiquidStack prevLiquid;
    private int prevGauge = 0;
    private int ticker = new Random().nextInt();

    public PeripheralTank(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "tank";
    }

    public String[] getMethodNames() {
        return new String[]{"suck", "suckUp", "suckDown", "drop", "dropUp", "dropDown", "getLiquid", "pack", "unpack"};
    }

    public Object[] callMethod(IComputerAccess computer, final int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: 
            case 2: {
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                final int doAmount = amount;
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        int adding;
                        World world = PeripheralTank.this.turtle.getWorld();
                        MovingObjectPosition mop = Util.rayTraceBlock(PeripheralTank.this.turtle, method == 0 ? PeripheralTank.this.turtle.getFacingDir() : (method == 1 ? 1 : 0));
                        TileEntity te = world.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        if (!(te instanceof ITankContainer)) {
                            if (PeripheralTank.this.liquid != null && 10000 - PeripheralTank.this.liquid.amount < 1000) {
                                return null;
                            }
                            int block = world.func_72798_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            if (Block.field_71973_m[block] == null || Block.field_71973_m[block].isAirBlock(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                                return null;
                            }
                            int meta = world.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            if (PeripheralTank.this.liquid != null && (PeripheralTank.this.liquid.itemID != block || PeripheralTank.this.liquid.itemMeta != meta)) {
                                return 0;
                            }
                            for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                                if (data.stillLiquid.itemID != block || data.stillLiquid.itemMeta != meta) continue;
                                world.func_72832_d(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 0, 0, 2);
                                world.func_72845_h(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                                if (PeripheralTank.this.liquid == null) {
                                    PeripheralTank.this.liquid = new LiquidStack(block, 1000, meta);
                                } else {
                                    PeripheralTank.this.liquid.amount += 1000;
                                }
                                return 1000;
                            }
                            return null;
                        }
                        ITankContainer container = (ITankContainer)te;
                        ForgeDirection side = ForgeDirection.getOrientation((int)mop.field_72310_e);
                        LiquidStack added = container.drain(side, adding = Math.min(doAmount, 10000 - (PeripheralTank.this.liquid == null ? 0 : PeripheralTank.this.liquid.amount)), false);
                        if (added == null || PeripheralTank.this.liquid != null && (added.itemID != PeripheralTank.this.liquid.itemID || added.itemMeta != PeripheralTank.this.liquid.itemMeta)) {
                            return 0;
                        }
                        added = container.drain(side, adding, true);
                        if (PeripheralTank.this.liquid == null) {
                            PeripheralTank.this.liquid = added;
                        } else {
                            PeripheralTank.this.liquid.amount += added.amount;
                        }
                        PeripheralTank.this.updateLiquid();
                        return added.amount;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 3: 
            case 4: 
            case 5: {
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                final int doAmount = amount;
                if (this.liquid == null) {
                    return new Object[]{0};
                }
                Future callback = TickHandler.addTickCallback(this.turtle.getWorld(), new Callable(){

                    public Object call() {
                        World world = PeripheralTank.this.turtle.getWorld();
                        MovingObjectPosition mop = Util.rayTraceBlock(PeripheralTank.this.turtle, method == 3 ? PeripheralTank.this.turtle.getFacingDir() : (method == 4 ? 1 : 0));
                        TileEntity te = world.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        if (!(te instanceof ITankContainer)) {
                            if (PeripheralTank.this.liquid.itemID >= Block.field_71973_m.length || Block.field_71973_m[PeripheralTank.this.liquid.itemID] == null || Block.field_71973_m[PeripheralTank.this.liquid.itemID].isAirBlock(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                                return new Object[]{null};
                            }
                            if (PeripheralTank.this.liquid.amount < 1000) {
                                return new Object[]{0};
                            }
                            int block = world.func_72798_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            if (Block.field_71973_m[block] != null && Block.field_71973_m[block].isAirBlock(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                                return new Object[]{null};
                            }
                            world.func_72832_d(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PeripheralTank.this.liquid.itemID, PeripheralTank.this.liquid.itemMeta, 2);
                            world.func_72845_h(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            PeripheralTank.this.liquid.amount -= 1000;
                            if (PeripheralTank.this.liquid.amount <= 0) {
                                PeripheralTank.this.liquid = null;
                            }
                            return new Object[]{1000};
                        }
                        ITankContainer container = (ITankContainer)te;
                        ForgeDirection side = ForgeDirection.getOrientation((int)mop.field_72310_e);
                        LiquidStack removing = PeripheralTank.this.liquid.copy();
                        removing.amount = Math.min(doAmount, PeripheralTank.this.liquid.amount);
                        int removed = container.fill(side, removing, true);
                        PeripheralTank.this.liquid.amount -= removed;
                        if (PeripheralTank.this.liquid.amount <= 0) {
                            PeripheralTank.this.liquid = null;
                        }
                        PeripheralTank.this.updateLiquid();
                        return removed;
                    }
                });
                return new Object[]{callback.get()};
            }
            case 6: {
                if (this.liquid == null) {
                    return new Object[]{null, 0};
                }
                return new Object[]{Util.getUUID(this.liquid), this.liquid.amount};
            }
            case 7: {
                if (this.liquid == null || this.liquid.amount < 1000) {
                    return new Object[]{false};
                }
                ItemStack slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{false};
                }
                LiquidStack filling = this.liquid.copy();
                filling.amount = 1000;
                ItemStack filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)filling, (ItemStack)slotstack);
                if (filled != null) {
                    this.liquid.amount -= filling.amount;
                    if (this.liquid.amount <= 0) {
                        this.liquid = null;
                    }
                    --slotstack.field_77994_a;
                    if (slotstack.field_77994_a <= 0) {
                        slotstack = null;
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                    Util.storeOrDrop(this.turtle, filled);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 8: {
                ItemStack slotstack = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                if (slotstack == null) {
                    return new Object[]{false};
                }
                for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                    if (!data.filled.func_77969_a(slotstack) || this.liquid != null && (!this.liquid.isLiquidEqual(data.stillLiquid) || 10000 - this.liquid.amount < data.stillLiquid.amount)) continue;
                    if (this.liquid == null) {
                        this.liquid = data.stillLiquid.copy();
                    } else {
                        this.liquid.amount += data.stillLiquid.amount;
                    }
                    if (slotstack.func_77973_b().func_77634_r()) {
                        slotstack = slotstack.func_77973_b().getContainerItemStack(slotstack);
                    } else {
                        --slotstack.field_77994_a;
                        if (slotstack.field_77994_a <= 0) {
                            slotstack = null;
                        }
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slotstack);
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return false;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        if (this.turtle.getWorld() != null && !this.turtle.getWorld().field_72995_K && ++this.ticker >= 20) {
            this.ticker = 0;
            this.updateLiquid();
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("liquid")) {
            this.liquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("liquid"));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.liquid != null) {
            NBTTagCompound liquid = new NBTTagCompound();
            this.liquid.writeToNBT(liquid);
            nbttagcompound.func_74782_a("liquid", (NBTBase)liquid);
        }
    }

    private void updateLiquid() {
        if (!this.areLiquidsEqual(this.liquid, this.prevLiquid)) {
            World world = this.turtle.getWorld();
            Vec3 pos = this.turtle.getPosition();
            int x = (int)Math.floor(pos.field_72450_a);
            int y = (int)Math.floor(pos.field_72448_b);
            int z = (int)Math.floor(pos.field_72449_c);
            world.func_72845_h(x, y, z);
            this.prevLiquid = this.liquid == null ? null : this.liquid.copy();
            ByteArrayDataOutput os = ByteStreams.newDataOutput();
            os.writeInt(x);
            os.writeInt(y);
            os.writeInt(z);
            if (this.liquid == null) {
                os.writeShort(Short.MIN_VALUE);
                os.writeShort(Short.MIN_VALUE);
                os.writeInt(Integer.MIN_VALUE);
            } else {
                os.writeShort(this.liquid.itemID);
                os.writeShort(this.liquid.itemMeta);
                os.writeInt(this.liquid.amount);
            }
            PacketDispatcher.sendPacketToAllAround((double)(pos.field_72450_a + 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c + 0.5), (double)64.0, (int)world.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)2, (byte[])os.toByteArray()));
        }
    }

    private boolean areLiquidsEqual(LiquidStack a, LiquidStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.itemID == b.itemID && a.itemMeta == b.itemMeta && a.amount == b.amount;
    }

    public int getTankPressure() {
        return 0;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return 10000;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (this.liquid != null && !resource.isLiquidEqual(this.liquid)) {
            return 0;
        }
        int toAdd = Math.min(10000 - (this.liquid == null ? 0 : this.liquid.amount), resource.amount);
        if (toAdd < 0) {
            toAdd = 0;
        }
        if (doFill) {
            if (this.liquid == null) {
                this.liquid = resource.copy();
                this.liquid.amount = toAdd;
            } else {
                this.liquid.amount += toAdd;
            }
            if (toAdd != 0) {
                this.updateLiquid();
            }
        }
        return toAdd;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null) {
            return null;
        }
        LiquidStack ret = this.liquid.copy();
        ret.amount = Math.min(this.liquid.amount, maxDrain);
        if (doDrain) {
            this.liquid.amount -= ret.amount;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
            }
            if (ret.amount != 0) {
                this.updateLiquid();
            }
        }
        return ret;
    }
}

