/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Vec3;

public class PeripheralSpeaker
implements IHostedPeripheral {
    private final Positionable positionable;

    public PeripheralSpeaker(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralSpeaker(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "speaker";
    }

    public String[] getMethodNames() {
        return new String[]{"speak"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                double speed;
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                String text = (String)arguments[0];
                if (text.length() > 255) {
                    text = text.substring(0, 255);
                }
                double d = speed = arguments.length > 1 ? (Double)arguments[1] : 0.0;
                if (speed < -1.0 || speed > 1.0) {
                    throw new Exception("bad speed " + speed + " (expected -1..1)");
                }
                Vec3 pos = this.positionable.getPosition();
                ByteArrayDataOutput os = ByteStreams.newDataOutput();
                os.writeDouble(pos.field_72450_a);
                os.writeDouble(pos.field_72448_b);
                os.writeDouble(pos.field_72449_c);
                os.writeUTF(text);
                os.writeDouble(speed);
                PacketDispatcher.sendPacketToAllAround((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (double)64.0, (int)this.positionable.getWorld().field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)8, (byte[])os.toByteArray()));
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

