/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.util.Random;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraftforge.common.ForgeDirection;

public class PeripheralSolar
implements IHostedPeripheral {
    final ITurtleAccess turtle;
    private final TurtleSide side;
    private int euBuffer = 0;
    private int ticker = new Random().nextInt(20);
    boolean sunVisible = false;
    boolean skyVisible = false;

    public PeripheralSolar(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public String getType() {
        return "solar";
    }

    public String[] getMethodNames() {
        return new String[]{"getProduction"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getProduction()};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        Vec3 pos;
        if (!MiscPeripherals.proxy.isServer()) {
            return;
        }
        if (++this.ticker >= 20 && (pos = this.turtle.getPosition()) != null) {
            this.ticker = 0;
            World world = this.turtle.getWorld();
            if (world != null) {
                int x = (int)Math.floor(pos.field_72450_a);
                int y = (int)Math.floor(pos.field_72448_b);
                int z = (int)Math.floor(pos.field_72449_c);
                if (MiscPeripherals.instance.sideSensitive) {
                    ForgeDirection dir = Util.getDirectionFromTurtleSide(this.side, this.turtle.getFacingDir());
                    x += dir.offsetX;
                    y += dir.offsetY;
                    z += dir.offsetZ;
                }
                this.skyVisible = !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z);
                boolean bl = this.sunVisible = world.func_72935_r() && this.skyVisible && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
            }
        }
        if (this.canUpdate()) {
            this.euBuffer += this.getProduction();
            while (this.euBuffer >= MiscPeripherals.instance.fuelEU) {
                this.euBuffer -= MiscPeripherals.instance.fuelEU * Util.addFuel(this.turtle, 1);
            }
        }
    }

    boolean canUpdate() {
        return this.sunVisible;
    }

    int getProduction() {
        return 1;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

