/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.io.InputStream;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PeripheralNote
implements IHostedPeripheral {
    private static final int MAX_INSTRUMENT = 4;
    private static final int MAX_NOTE = 24;
    private static final int MAX_TICKER = 5;
    private final Positionable positionable;
    private int ticker = 0;
    private InputStream is;

    public PeripheralNote(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
    }

    public PeripheralNote(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
    }

    public String getType() {
        return "note";
    }

    public String[] getMethodNames() {
        return new String[]{"playNote", "playSound"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (++this.ticker > 5) {
                    throw new Exception("too many notes (over 5 per tick)");
                }
                int instrument = ((Double)arguments[0]).intValue();
                if (instrument < 0 || instrument > 4) {
                    throw new Exception("bad instrument " + instrument + " (expected 0-" + 4 + ")");
                }
                int note = ((Double)arguments[1]).intValue();
                if (note < 0 || note > 24) {
                    throw new Exception("bad note " + note + " (expected 0-" + 24 + ")");
                }
                Vec3 position = this.positionable.getPosition();
                World world = this.positionable.getWorld();
                if (position == null || world == null) {
                    return new Object[0];
                }
                ByteArrayDataOutput os = ByteStreams.newDataOutput();
                os.writeDouble(position.field_72450_a);
                os.writeDouble(position.field_72448_b);
                os.writeDouble(position.field_72449_c);
                os.writeByte(instrument);
                os.writeByte(note);
                PeripheralNote.playNote(world, position.field_72450_a, position.field_72448_b, position.field_72449_c, instrument, note);
                PacketDispatcher.sendPacketToAllAround((double)(position.field_72450_a + 0.5), (double)(position.field_72448_b + 0.5), (double)(position.field_72449_c + 0.5), (double)64.0, (int)world.field_73011_w.field_76574_g, (Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)0, (byte[])os.toByteArray()));
                return new Object[0];
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                String sound = (String)arguments[0];
                double volume = 1.0;
                if (arguments.length > 1) {
                    if (!(arguments[1] instanceof Double)) {
                        throw new Exception("bad argument #2 (expected number)");
                    }
                    volume = (Double)arguments[1];
                }
                double pitch = 1.0;
                if (arguments.length > 2) {
                    if (!(arguments[2] instanceof Double)) {
                        throw new Exception("bad argument #3 (expected number)");
                    }
                    volume = (Double)arguments[2];
                }
                Vec3 position = this.positionable.getPosition();
                this.positionable.getWorld().func_72908_a(position.field_72450_a + 0.5, position.field_72448_b + 0.5, position.field_72449_c + 0.5, sound, (float)volume, (float)pitch);
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
        this.ticker = 0;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    public static void playNote(World world, double x, double y, double z, int instrument, int note) {
        String instrumentName;
        float inflate = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        switch (instrument) {
            case 1: {
                instrumentName = "bd";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bassattack";
                break;
            }
            default: {
                instrumentName = "harp";
            }
        }
        world.func_72908_a(x + 0.5, y + 0.5, z + 0.5, "note." + instrumentName, 3.0f, inflate);
        world.func_72869_a("note", x + 0.5, y + 1.2, z + 0.5, (double)note / 24.0, 0.0, 0.0);
    }
}

