/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import miscperipherals.core.LuaManager;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TilePeripheralWrapper;
import miscperipherals.util.Positionable;
import miscperipherals.util.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class PeripheralChatBox
implements IHostedPeripheral {
    private static final int TICKER_INTERVAL = 20;
    private final Positionable positionable;
    private Map computers = new WeakHashMap();
    private int ticker = 0;
    private int subticker = 0;

    public PeripheralChatBox(ITurtleAccess turtle) {
        this.positionable = new Positionable.PositionableTurtle(turtle);
        this.init();
    }

    public PeripheralChatBox(TilePeripheralWrapper tile) {
        this.positionable = new Positionable.PositionableTile(tile);
        this.init();
    }

    public String getType() {
        return "chat";
    }

    public String[] getMethodNames() {
        return new String[]{"say", "tell"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new Exception("bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Boolean)) {
                    throw new Exception("bad argument #3 (expected boolean)");
                }
                if (++this.ticker > MiscPeripherals.instance.chatSayRate + 1) {
                    throw new Exception("too many messages (over " + MiscPeripherals.instance.chatSayRate + " per tick)");
                }
                String message = Util.sanitize((String)arguments[0], MiscPeripherals.instance.chatColorCodes);
                double range = Math.min(arguments.length > 1 ? (Double)arguments[1] : Double.MAX_VALUE, MinecraftServer.func_71276_C().func_71262_S() ? (MiscPeripherals.instance.chatSayRange < 0 ? Double.MAX_VALUE : (double)MiscPeripherals.instance.chatSayRange) : Double.MAX_VALUE);
                boolean unlimitedVertical = arguments.length > 2 ? ((Boolean)arguments[2]).booleanValue() && MiscPeripherals.instance.chatSayUnlimitedVertical : false;
                Vec3 pos = this.positionable.getPosition();
                String msg = "[#" + (MiscPeripherals.instance.chatLogCoords ? ":" + (int)Math.floor(pos.field_72450_a) + "," + (int)Math.floor(pos.field_72448_b) + "," + (int)Math.floor(pos.field_72449_c) : "") + "] " + message;
                for (EntityPlayer player : this.positionable.getWorld().field_73010_i) {
                    Vec3 playerpos = Util.getPosition((Entity)player, 1.0f);
                    if (unlimitedVertical) {
                        playerpos.field_72448_b = pos.field_72448_b;
                    }
                    if (pos.func_72438_d(playerpos) > range) continue;
                    player.func_70006_a(msg);
                }
                return new Object[]{true};
            }
            case 1: {
                if (arguments.length < 2) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof String)) {
                    throw new Exception("bad argument #2 (expected string)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new Exception("bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Boolean)) {
                    throw new Exception("bad argument #4 (expected boolean)");
                }
                if (++this.ticker > MiscPeripherals.instance.chatSayRate + 1) {
                    throw new Exception("too many messages (over " + MiscPeripherals.instance.chatSayRate + " per tick)");
                }
                String to = Util.sanitize((String)arguments[0], false);
                String message = Util.sanitize((String)arguments[1], MiscPeripherals.instance.chatColorCodes);
                double range = Math.min(arguments.length > 2 ? (Double)arguments[2] : Double.MAX_VALUE, MinecraftServer.func_71276_C().func_71262_S() ? (MiscPeripherals.instance.chatSayRange < 0 ? Double.MAX_VALUE : (double)MiscPeripherals.instance.chatSayRange) : Double.MAX_VALUE);
                boolean unlimitedVertical = arguments.length > 3 ? ((Boolean)arguments[3]).booleanValue() && MiscPeripherals.instance.chatSayUnlimitedVertical : false;
                Vec3 pos = this.positionable.getPosition();
                String msg = "[#" + (MiscPeripherals.instance.chatLogCoords ? ":" + (int)Math.floor(pos.field_72450_a) + "," + (int)Math.floor(pos.field_72448_b) + "," + (int)Math.floor(pos.field_72449_c) : "") + "] " + message;
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(to);
                if (player == null) {
                    return new Object[]{false};
                }
                Vec3 playerpos = Util.getPosition((Entity)player, 1.0f);
                if (unlimitedVertical) {
                    playerpos.field_72448_b = pos.field_72448_b;
                }
                if (pos.func_72438_d(playerpos) > range) {
                    return new Object[]{false};
                }
                player.func_70006_a(msg);
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
        this.computers.put(computer, true);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public void update() {
        if (++this.subticker > 20) {
            this.ticker = 0;
            this.subticker = 0;
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    private void onChat(EntityPlayer player, String message) {
        if (this.notInRange(player)) {
            return;
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat", new Object[]{player.func_70023_ak(), message});
        }
    }

    private void onDeath(EntityPlayer player, DamageSource source) {
        Entity ent;
        if (this.notInRange(player)) {
            return;
        }
        String killer = null;
        if (source instanceof EntityDamageSource && (ent = ((EntityDamageSource)source).func_76346_g()) != null) {
            killer = ent.func_70023_ak();
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat_death", new Object[]{player.func_70023_ak(), killer, source.field_76373_n});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean notInRange(EntityPlayer player) {
        Vec3 pos = this.positionable.getPosition();
        if (pos == null) {
            MiscPeripherals.log.warning("Chat box pos is null!");
            return true;
        }
        if (MinecraftServer.func_71276_C() == null) {
            MiscPeripherals.log.warning("Server is null for chat box at " + pos.field_72450_a + "," + pos.field_72448_b + "," + pos.field_72449_c + " on " + this.positionable.getWorld() + "!");
            return true;
        }
        if (!MinecraftServer.func_71276_C().func_71262_S()) return false;
        double d = pos.func_72438_d(Util.getPosition((Entity)player, 1.0f));
        double d2 = MiscPeripherals.instance.chatReadRange < 0.0 ? Double.MAX_VALUE : MiscPeripherals.instance.chatReadRange;
        if (!(d > d2)) return false;
        return true;
    }

    private void init() {
        ChatListener.peripherals.put(this, true);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener());
    }

    public static class ChatListener {
        private static Map peripherals = Collections.synchronizedMap(new WeakHashMap());

        @ForgeSubscribe
        public void onServerChat(ServerChatEvent event) {
            for (PeripheralChatBox peripheral : peripherals.keySet()) {
                peripheral.onChat((EntityPlayer)event.player, event.message);
            }
        }

        @ForgeSubscribe
        public void onLivingDeath(LivingDeathEvent event) {
            if (!(event.entity instanceof EntityPlayerMP)) {
                return;
            }
            for (PeripheralChatBox peripheral : peripherals.keySet()) {
                peripheral.onDeath((EntityPlayer)((EntityPlayerMP)event.entity), event.source);
            }
        }
    }
}

