/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import miscperipherals.core.LuaManager;
import miscperipherals.core.TickHandler;
import miscperipherals.safe.ReflectionStore;
import miscperipherals.safe.Reflector;
import miscperipherals.util.FakePlayer;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class PeripheralAlchemist
implements IHostedPeripheral {
    public final ITurtleAccess turtle;
    public long miniumCharge = 0L;
    private String error;

    public PeripheralAlchemist(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "alchemist";
    }

    public String[] getMethodNames() {
        return new String[]{"transmuteItem", "transmute", "transmuteUp", "transmuteDown", "rechargeMinium", "getMiniumCharge", "getError"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                ItemStack slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                int amount = Integer.MIN_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (slot == null) {
                    this.error = "No item to transmute";
                    return new Object[]{false};
                }
                if (amount == Integer.MIN_VALUE) {
                    amount = slot.field_77994_a;
                }
                if (amount < 1) {
                    this.error = "Zero items to transmute";
                    return new Object[]{false};
                }
                if (amount > 8) {
                    amount = 8;
                }
                InventoryCrafting inv = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer var1) {
                        return true;
                    }
                }, 3, 3);
                inv.func_70299_a(0, new ItemStack(ReflectionStore.miniumStone));
                ItemStack single = slot.func_77946_l();
                single.field_77994_a = 1;
                for (int i = 0; i < amount; ++i) {
                    inv.func_70299_a(i + 1, single);
                }
                ItemStack match = CraftingManager.func_77594_a().func_82787_a(inv, this.turtle.getWorld());
                if (match == null) {
                    this.error = "No transmutation recipe";
                    return new Object[]{false};
                }
                if (!this.useMinium(1, true)) {
                    this.error = "Not enough minium charge";
                    return new Object[]{false};
                }
                slot.field_77994_a -= amount;
                if (slot.field_77994_a <= 0) {
                    slot = null;
                }
                this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slot);
                Util.storeOrDrop(this.turtle, match);
                return new Object[]{true};
            }
            case 1: 
            case 2: 
            case 3: {
                boolean sneak = false;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Boolean)) {
                        throw new Exception("bad argument #1 (expected boolean)");
                    }
                    sneak = (Boolean)arguments[0];
                }
                final boolean doSneak = sneak;
                final int direction = method == 1 ? this.turtle.getFacingDir() : (method == 2 ? 1 : 0);
                final World world = this.turtle.getWorld();
                Vec3 pos = this.turtle.getPosition();
                final int x = (int)Math.floor(pos.field_72450_a) + Facing.field_71586_b[direction];
                final int y = (int)Math.floor(pos.field_72448_b) + Facing.field_71587_c[direction];
                final int z = (int)Math.floor(pos.field_72449_c) + Facing.field_71585_d[direction];
                Future callback = TickHandler.addTickCallback(world, new Callable(){

                    public Boolean call() {
                        try {
                            if (!world.func_72899_e(x, y, z)) {
                                PeripheralAlchemist.this.error = "Block unloaded";
                                return false;
                            }
                            if (!PeripheralAlchemist.this.useMinium(1, false)) {
                                PeripheralAlchemist.this.error = "Not enough minium charge";
                                return false;
                            }
                            int id = world.func_72798_a(x, y, z);
                            if (Block.field_71973_m[id] == null || Block.field_71973_m[id].isAirBlock(world, x, y, z)) {
                                PeripheralAlchemist.this.error = "No block to transmute";
                                return false;
                            }
                            int meta = world.func_72805_g(x, y, z);
                            ItemStack next = new ItemStack(id, 1, meta);
                            do {
                                next = (ItemStack)Reflector.invoke("com.pahimar.ee3.core.helper.TransmutationHelper", "getNextBlock", ItemStack.class, next.field_77993_c, next.func_77960_j());
                                System.out.println(next);
                            } while (!doSneak && next != null && Block.field_71973_m[next.field_77993_c] instanceof BlockSand);
                            if (next == null) {
                                PeripheralAlchemist.this.error = "Nothing to transmute to";
                                return false;
                            }
                            ItemStack stone = new ItemStack(ReflectionStore.miniumStone);
                            FakePlayer player = FakePlayer.get(PeripheralAlchemist.this.turtle);
                            player.alignToTurtle(PeripheralAlchemist.this.turtle, direction);
                            player.setHeldItem(stone);
                            player.func_70052_a(1, doSneak);
                            Event event = (Event)Reflector.construct("com.pahimar.ee3.event.WorldTransmutationEvent", Event.class, new Object[]{Reflector.getField("com.pahimar.ee3.lib.ActionTypes", "TRANSMUTATION", Object.class), stone, player, world, x, y, z, false, next.field_77993_c + ":" + next.func_77960_j()});
                            if (event != null) {
                                Event req = (Event)Reflector.construct("com.pahimar.ee3.event.ActionRequestEvent", Event.class, new Object[]{player, event, x, y, z, direction});
                                MinecraftForge.EVENT_BUS.post(req);
                                if (Reflector.getField(req, "allowEvent", Event.Result.class) != Event.Result.DENY) {
                                    MinecraftForge.EVENT_BUS.post(event);
                                }
                                if (Reflector.getField(event, "actionResult", Object.class) == ReflectionStore.actionResultSuccess) {
                                    PeripheralAlchemist.this.useMinium(1, true);
                                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (String)Reflector.getField("com.pahimar.ee3.lib.Sounds", "TRANSMUTE", String.class), 0.5f, 1.0f);
                                    return true;
                                }
                                PeripheralAlchemist.this.error = "Transmutation denied";
                            } else {
                                PeripheralAlchemist.this.error = "Internal error";
                            }
                            return false;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                });
                return new Object[]{callback.get()};
            }
            case 4: {
                ItemStack slot = this.turtle.getSlotContents(this.turtle.getSelectedSlot());
                int amount = Integer.MIN_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new Exception("bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (slot == null) {
                    this.error = "No item to recharge from";
                    return new Object[]{false};
                }
                long recharge = 0L;
                if (slot.field_77993_c == ReflectionStore.miniumStone.field_77779_bT) {
                    recharge = Math.min(amount == Integer.MIN_VALUE ? Integer.MAX_VALUE : amount, ReflectionStore.miniumStone.func_77612_l() - 1 - slot.func_77960_j());
                    amount = 1;
                } else if (slot.field_77993_c == ReflectionStore.philStone.field_77779_bT) {
                    recharge = Long.MAX_VALUE;
                    amount = 1;
                }
                this.miniumCharge = recharge == Long.MAX_VALUE ? Long.MAX_VALUE : (this.miniumCharge += recharge * (long)amount);
                if (recharge > 0L) {
                    slot.field_77994_a -= amount;
                    if (slot.field_77994_a <= 0) {
                        slot = null;
                    }
                    this.turtle.setSlotContents(this.turtle.getSelectedSlot(), slot);
                } else {
                    this.error = "Not a minium charge source";
                }
                return new Object[]{recharge};
            }
            case 5: {
                return new Object[]{this.miniumCharge};
            }
            case 6: {
                return new Object[]{this.error};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.miniumCharge = nbttagcompound.func_74763_f("miniumCharge");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74772_a("miniumCharge", this.miniumCharge);
    }

    private boolean useMinium(int amount, boolean doUse) {
        if (this.miniumCharge == Long.MAX_VALUE || amount < 1) {
            return true;
        }
        if ((long)amount > this.miniumCharge) {
            return false;
        }
        if (doUse) {
            this.miniumCharge -= (long)amount;
        }
        return true;
    }
}

