/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.tools.IToolWrench;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileChargeStation;
import miscperipherals.tile.TileGateReader;
import miscperipherals.upgrade.UpgradeGateReader;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleBuildCraftCore
extends Module {
    public static boolean enableGateReader = true;

    @Override
    public void onPreInit() {
        enableGateReader = MiscPeripherals.instance.settings.get("features", "enableGateReader", enableGateReader, "Enable the Gate Reader peripheral and turtle upgrade").getBoolean(enableGateReader);
    }

    @Override
    public void onInit() {
        if (enableGateReader) {
            MiscPeripherals.instance.blockAlpha.registerTile(6).setClass(TileGateReader.class).setSprites("gate").setName("gateReader").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileGateReader.class, (String)"MiscPeripherals Gate Reader");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.gateReader.name", "Gate Reader");
            GameRegistry.registerCustomItemStack((String)"gateReader", (ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 6));
            MiscPeripherals.registerUpgrade(new UpgradeGateReader());
        }
    }

    @Override
    public void onPostInit() {
        if (enableGateReader) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 6), new Object[]{"RWR", "WGW", "RWR", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('G'), "MiscPeripherals$bcGate", Character.valueOf('W'), "MiscPeripherals$bcPipeWire"}));
        }
        TileChargeStation.PLUGINS.add(new TileChargeStation.ChargeStationPlugin(){

            @Override
            public void writeToNBT(TileChargeStation station, NBTTagCompound compound) {
                ((IPowerProvider)station.bcProvider).writeToNBT(compound);
            }

            @Override
            public void update(TileChargeStation station) {
                ((IPowerProvider)station.bcProvider).update((IPowerReceptor)station);
            }

            @Override
            public void unload(TileChargeStation station) {
            }

            @Override
            public void readFromNBT(TileChargeStation station, NBTTagCompound compound) {
                ((IPowerProvider)station.bcProvider).readFromNBT(compound);
            }

            @Override
            public boolean onBlockActivated(TileChargeStation station, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
                ItemStack held = player.func_71045_bC();
                if (held != null && held.func_77973_b() instanceof IToolWrench) {
                    station.setFacing(side);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isBattery(TileChargeStation station, ItemStack item) {
                return false;
            }

            @Override
            public void initialize(TileChargeStation station) {
                station.bcProvider = PowerFramework.currentFramework.createPowerProvider();
                ((IPowerProvider)station.bcProvider).configure(0, 0, station.powerRequest(ForgeDirection.UNKNOWN), 0, station.powerRequest(ForgeDirection.UNKNOWN));
            }

            @Override
            public boolean isDisabled(TileChargeStation station) {
                return false;
            }
        });
    }

    @Override
    public void handleNetworkMessage(NetHandler source, boolean isClient, ByteArrayDataInput data) {
    }

    public static ItemStack getBCItem(String module, String item) {
        ItemStack ret = GameRegistry.findItemStack((String)("BuildCraft|" + module), (String)item, (int)1);
        if (ret == null) {
            ret = Util.createItemStackNC(Reflector.getField("buildcraft.BuildCraft" + module, item, Object.class), 1, 0);
        }
        return ret;
    }
}

