/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.item;

import com.google.common.base.Strings;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import miscperipherals.api.ISmEntity;
import miscperipherals.api.ISmEntityFactory;
import miscperipherals.api.ISmSender;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.safe.Reflector;
import miscperipherals.util.SmallNetHelper;
import miscperipherals.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.opengl.GL11;

public class ItemSmartHelmet
extends ItemArmor
implements ISpecialArmor,
ISmEntityFactory {
    public static final int LINES = 5;
    public static String[] clientLines = new String[5];
    private static Object fwFontRenderer;
    private Icon icon;
    private Map logicCache = new WeakHashMap();

    public ItemSmartHelmet(int id) {
        super(id, EnumArmorMaterial.IRON, 0, 0);
        this.func_77656_e(0);
        this.func_77637_a(MiscPeripherals.instance.tabMiscPeripherals);
        fwFontRenderer = Reflector.invoke("dan200.ComputerCraft", "getFixedWidthFontRenderer", Object.class, new Object[0]);
        SmallNetHelper.bindEntity(EntityPlayerMP.class, this);
    }

    public boolean isValidArmor(ItemStack stack, int armorType) {
        return armorType == 0;
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this));
    }

    public Icon func_77617_a(int meta) {
        return this.icon;
    }

    public void func_94581_a(IconRegister reg) {
        this.icon = reg.func_94245_a("MiscPeripherals:smartHelmet");
    }

    public String func_77628_j(ItemStack par1ItemStack) {
        return "Smart Helmet";
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, int layer) {
        return "/mods/MiscPeripherals/textures/armor/smartHelmet.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLiving player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLiving entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
    }

    public ISmEntity getEntity(EntityPlayer entity) {
        SmartHelmetLogic logic = (SmartHelmetLogic)this.logicCache.get(entity);
        if (logic == null) {
            logic = new SmartHelmetLogic(entity);
            this.logicCache.put(entity, logic);
        }
        return logic;
    }

    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74330_P) {
            GL11.glDisable((int)3008);
            Gui.func_73734_a((int)0, (int)0, (int)resolution.func_78326_a(), (int)(6 + clientLines.length * 10), (int)0x7F7F7F7F);
            GL11.glEnable((int)3008);
            for (int i = 0; i < clientLines.length; ++i) {
                ItemSmartHelmet.drawFixedWidthString(mc, clientLines[i], 3, 3 + i * 10);
            }
        }
    }

    public static void drawFixedWidthString(Minecraft mc, String text, int x, int y) {
        if (text == null) {
            text = "";
        }
        if (fwFontRenderer == null) {
            mc.field_71466_p.func_78276_b(text, x, y, 0xFFFFFF);
        } else {
            Reflector.invoke(fwFontRenderer, "drawString", Object.class, text, x, y, Strings.repeat((String)"f", (int)text.length()), Float.valueOf(2.0f), false);
        }
    }

    public static void sendToPlayer(EntityPlayer player, String line) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ByteArrayDataOutput os = ByteStreams.newDataOutput();
        os.writeUTF(Util.sanitize(line.length() > 255 ? line.substring(0, 255) : line, false).replaceAll("\n|\r|\t|\b", ""));
        ((EntityPlayerMP)player).field_71135_a.func_72567_b((Packet)PacketDispatcher.getTinyPacket((Object)MiscPeripherals.instance, (short)7, (byte[])os.toByteArray()));
    }

    public static class SmartHelmetLogic
    implements ISmEntity {
        public final EntityPlayer player;

        public SmartHelmetLogic(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public Vec3 getPosition() {
            return Util.getPosition((Entity)this.player, 1.0f);
        }

        @Override
        public World getWorld() {
            return this.player.field_70170_p;
        }

        @Override
        public double getPower() {
            return 0.0;
        }

        @Override
        public void receive(ISmSender from, String type, String payload) {
            if (type.equalsIgnoreCase("smartHelmet")) {
                ItemSmartHelmet.sendToPlayer(this.player, payload);
            }
        }
    }
}

