/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.external;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dan200.computer.api.IComputerAccess;
import miscperipherals.external.ExtTrack;
import miscperipherals.module.ModuleRailcraft;
import miscperipherals.safe.Reflector;
import miscperipherals.util.Util;
import mods.railcraft.api.tracks.ITrackInstance;

public class ExtTrackLocomotive
extends ExtTrack {
    public static final Enum[] locoModes;
    public static final BiMap modeLookup;

    public ExtTrackLocomotive(ITrackInstance track) {
        super(track);
    }

    @Override
    public String getType() {
        return "trackLocomotive";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"set", "get"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                String smode = ((String)arguments[0]).toLowerCase();
                Enum mode = (Enum)modeLookup.get((Object)smode);
                if (mode == null) {
                    throw new Exception("bad locomotive mode " + Util.camelCase((String)arguments[0]) + " (expected " + Util.joinCC("/", locoModes) + ")");
                }
                Reflector.setField(this.track, "mode", (byte)mode.ordinal());
                ModuleRailcraft.updateTrack(this.track);
                return this.callMethod(computer, 1, arguments);
            }
            case 1: {
                return new Object[]{Util.camelCase(locoModes[(Byte)Reflector.getField(this.track, "mode", Byte.class)].toString())};
            }
        }
        return new Object[0];
    }

    static {
        modeLookup = HashBiMap.create();
        for (Enum mode : locoModes = (Enum[])Reflector.invoke("mods.railcraft.common.carts.EntityLocomotive$LocoMode", "values", Enum[].class, new Object[0])) {
            modeLookup.put((Object)Util.camelCase(mode.toString()).toLowerCase(), (Object)mode);
        }
    }
}

