/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.external;

import dan200.computer.api.IComputerAccess;
import miscperipherals.external.ExtTrack;
import miscperipherals.module.ModuleRailcraft;
import miscperipherals.safe.Reflector;
import mods.railcraft.api.tracks.ITrackInstance;

public class ExtTrackLimiter
extends ExtTrack {
    private int locoSpeeds = 0;

    public ExtTrackLimiter(ITrackInstance track) {
        super(track);
        Object[] locoSpeeds = (Object[])Reflector.invoke("mods.railcraft.common.carts.EntityLocomotive$LocoSpeed", "values", Object[].class, new Object[0]);
        if (locoSpeeds != null) {
            this.locoSpeeds = locoSpeeds.length;
        }
    }

    @Override
    public String getType() {
        return "trackLimiter";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"set", "get"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int speed = (int)Math.floor((Double)arguments[0]);
                if (speed < 1 || speed > this.locoSpeeds) {
                    throw new Exception("bad locomotive speed " + speed + " (expected 1-" + this.locoSpeeds + ")");
                }
                Reflector.setField(this.track, "mode", (byte)speed);
                ModuleRailcraft.updateTrack(this.track);
                return this.callMethod(computer, 1, arguments);
            }
            case 1: {
                return new Object[]{(Byte)Reflector.getField(this.track, "mode", Byte.class) % this.locoSpeeds};
            }
        }
        return new Object[0];
    }
}

