/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import miscperipherals.upgrade.UpgradeTank;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class EventHandler {
    public static Map dropConsumers = Collections.synchronizedMap(new WeakHashMap());
    public static List itemConsumers = Collections.synchronizedList(new ArrayList());

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (Map.Entry entry : LiquidDictionary.getLiquids().entrySet()) {
            this.onLiquidRegister(new LiquidDictionary.LiquidRegisterEvent((String)entry.getKey(), (LiquidStack)entry.getValue()));
        }
    }

    @ForgeSubscribe
    public void onLiquidRegister(LiquidDictionary.LiquidRegisterEvent event) {
        UpgradeTank.LIQUIDS.put(new ChunkCoordIntPair(event.Liquid.itemID, event.Liquid.itemMeta), event.Name.toLowerCase());
    }

    @ForgeSubscribe
    public void onLivingDrops(LivingDropsEvent event) {
        DropConsumer consumer = (DropConsumer)dropConsumers.remove(event.entityLiving);
        if (consumer != null) {
            consumer.onDrops(event.source, event.drops, event.lootingLevel, event.recentlyHit, event.specialDropValue);
        }
    }

    @ForgeSubscribe(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityItem) {
            for (ItemConsumer consumer : itemConsumers) {
                consumer.onItem((EntityItem)event.entity);
            }
        }
    }

    public static interface ItemConsumer {
        public void onItem(EntityItem var1);
    }

    public static interface DropConsumer {
        public void onDrops(DamageSource var1, ArrayList var2, int var3, boolean var4, int var5);
    }
}

