/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.ClientUtils;
import codechicken.core.asm.InterfaceDependancies;
import codechicken.core.data.MCDataInput;
import codechicken.core.data.MCDataOutput;
import codechicken.core.lighting.LazyLightMatrix;
import codechicken.core.raytracer.IndexedCuboid6;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.RedundantTransformation;
import codechicken.core.vec.Rotation;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.Vector3;
import codechicken.microblock.FaceMicroClass;
import codechicken.microblock.JMicroShrinkRender;
import codechicken.microblock.MicroOcclusion;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.JPartialOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.logic.RenderWireless;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraftforge.common.ForgeDirection;

@InterfaceDependancies
public abstract class WirelessPart
extends JCuboidPart
implements TFacePart,
IFaceRedstonePart,
JNormalOcclusion,
JPartialOcclusion,
JMicroShrinkRender {
    private static Cuboid6[] nBoxes = new Cuboid6[6];
    public byte state;
    public String owner;
    public Cuboid6 baseRenderBounds;
    public int baseRenderMask;
    protected int spinoffset;

    static {
        Cuboid6 base = new Cuboid6(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        int s = 0;
        while (s < 6) {
            WirelessPart.nBoxes[s] = base.copy().transform(Rotation.sideRotations[s].at(Vector3.center));
            ++s;
        }
    }

    public int rotation() {
        return this.state & 3;
    }

    public void setRotation(int rot) {
        this.state = (byte)(this.state & 0xFC | rot);
    }

    public int side() {
        return this.state >> 2 & 7;
    }

    public void setSide(int side) {
        this.state = (byte)(this.state & 0xE3 | side << 2);
    }

    public int shape() {
        return this.state & 0x1F;
    }

    public boolean active() {
        return (this.state & 0x20) > 0;
    }

    public void setActive(boolean active) {
        this.state = (byte)(this.state & 0xDF);
        if (active) {
            this.state = (byte)(this.state | 0x20);
        }
    }

    public boolean disabled() {
        return (this.state & 0x40) > 0;
    }

    public void setDisabled(boolean disabled) {
        this.state = (byte)(this.state & 0xBF);
        if (disabled) {
            this.state = (byte)(this.state | 0x40);
        }
    }

    public int getPoweringLevel() {
        return RedstoneInteractions.getPowerTo((TMultiPart)this, (int)Rotation.rotateSide((int)this.side(), (int)this.rotation()));
    }

    public Transformation rotationT() {
        return Rotation.sideOrientation((int)this.side(), (int)this.rotation());
    }

    public void load(bs tag) {
        this.state = tag.c("state");
        if (tag.b("owner")) {
            this.owner = tag.i("owner");
        }
    }

    public void save(bs tag) {
        tag.a("state", this.state);
        if (this.owner != null) {
            tag.a("owner", this.owner);
        }
    }

    public void readDesc(MCDataInput packet) {
        this.state = packet.readByte();
    }

    public void read(MCDataInput packet) {
        super.read(packet);
        this.onPartChanged();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.state);
    }

    public void onWorldJoin() {
        if (!this.world().I) {
            this.addToEther();
        }
    }

    public void onWorldSeparate() {
        if (!this.world().I) {
            this.removeFromEther();
        }
    }

    public int getFace() {
        return this.side();
    }

    public boolean canConnectRedstone(int side) {
        return side == Rotation.rotateSide((int)this.side(), (int)this.rotation());
    }

    public void onNeighborChanged() {
        this.dropIfCantStay();
    }

    public wm pickItem(ara hit) {
        return this.getItem();
    }

    public Iterable<wm> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return this.strongPowerLevel(side);
    }

    public void updateChange() {
        this.tile().markDirty();
        this.tile().notifyPartChange();
        this.sendDescUpdate();
    }

    public boolean dropIfCantStay() {
        BlockCoord pos = new BlockCoord(this.getTile()).offset(this.side());
        if (!this.world().isBlockSolidOnSide(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)(this.side() ^ 1)))) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        this.tile().remPart((TMultiPart)this);
        TileMultipart.dropItem((wm)this.getItem(), (aab)this.world(), (Vector3)Vector3.fromTileEntityCenter((aqp)this.getTile()));
    }

    public void setupPlacement(sq player, int side) {
        this.setSide(side ^ 1);
        this.setRotation(Rotation.getSidedRotation((sq)player, (int)side));
        this.owner = player.bS;
    }

    public abstract wm getItem();

    public abstract void addToEther();

    public abstract void removeFromEther();

    public abstract Cuboid6 getExtensionBB();

    public abstract int modelId();

    public int textureSet() {
        return this.active() ? 1 : 0;
    }

    public abstract Vector3 getPearlPos();

    public Transformation getPearlRotation() {
        return new RedundantTransformation();
    }

    public double getPearlScale() {
        return 0.05;
    }

    public abstract double getPearlSpin();

    public double getFloating() {
        if (this.tile() != null) {
            return RedstoneEther.getSineWave((double)(ClientUtils.getRenderTime() + (double)(this.x() * 3) + (double)(this.y() * 5) + (double)(this.z() * 9)), (int)7);
        }
        return 0.0;
    }

    public boolean allowCompleteOcclusion() {
        return false;
    }

    public Cuboid6 getBounds() {
        return WirelessPart.baseBounds(this.side());
    }

    public Iterable<Cuboid6> getPartialOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(nBoxes[this.side()], this.getExtensionBB());
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, this.getBounds()));
    }

    public float getStrength(ara hit, sq player) {
        return 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 pos, LazyLightMatrix olm, int pass) {
        if (pass == 0) {
            RenderWireless.renderWorld(this);
        }
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderWireless.renderPearl(pos, this);
        }
    }

    public void onPartChanged() {
        if (this.world().I) {
            this.baseRenderBounds = this.getBounds().copy();
            this.baseRenderMask = MicroOcclusion.recalcBounds((JMicroShrinkRender)this, (Cuboid6)this.baseRenderBounds);
            this.baseRenderBounds = this.baseRenderBounds.transform(this.rotationT().at(Vector3.center).inverse());
        } else {
            this.onNeighborChanged();
        }
    }

    public int getSlotMask() {
        return 1 << this.getSlot();
    }

    public boolean solid(int side) {
        return false;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public int getPriorityClass() {
        return -1;
    }

    public int getSize() {
        return 1;
    }

    public int getSlot() {
        return this.side();
    }

    public boolean isTransparent() {
        return false;
    }

    public static Cuboid6 baseBounds(int i) {
        return FaceMicroClass.aBounds()[0x10 | i];
    }

    public boolean activate(sq player, ara hit, wm held) {
        if (hit.e == (this.side() ^ 1) && player.ag()) {
            int r = this.rotation();
            this.setRotation((r + 1) % 4);
            if (!this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this)) {
                this.setRotation(r);
                return false;
            }
            if (!this.world().I) {
                this.updateChange();
                this.onPartChanged();
            } else {
                this.setRotation(r);
            }
            return true;
        }
        return false;
    }
}

