/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.colour.ColourRGBA;
import codechicken.core.lighting.LightModel;
import codechicken.core.render.CCModel;
import codechicken.core.render.CCModelLibrary;
import codechicken.core.render.CCRenderState;
import codechicken.core.render.IUVTransformation;
import codechicken.core.render.IVertexModifier;
import codechicken.core.render.MultiIconTransformation;
import codechicken.core.render.RenderUtils;
import codechicken.core.render.TextureUtils;
import codechicken.core.vec.CoordinateSystem;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.RightHanded;
import codechicken.core.vec.Rotation;
import codechicken.core.vec.Scale;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.Translation;
import codechicken.core.vec.Vector3;
import codechicken.wirelessredstone.logic.TransceiverPart;
import codechicken.wirelessredstone.logic.WirelessPart;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class RenderWireless {
    private static MultiIconTransformation model_icont;
    private static MultiIconTransformation[] base_icont;
    private static CCModel[][] models;
    private static LightModel lm;
    private static IVertexModifier rlm;

    static {
        base_icont = new MultiIconTransformation[2];
        models = new CCModel[3][24];
        lm = new LightModel().setAmbient(new Vector3(0.7, 0.7, 0.7)).addLight(new LightModel.Light(new Vector3(0.2, 1.0, -0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(-0.2, 1.0, 0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(0.7, -1.0, -0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2))).addLight(new LightModel.Light(new Vector3(-0.7, -1.0, 0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2)));
        rlm = lm.reducePlanar();
        Map modelMap = CCModel.parseObjModels((String)"/codechicken/wirelessredstone/logic/models.obj", (int)7, (CoordinateSystem)new RightHanded());
        CCModel tstand = MultiIconTransformation.setIconIndex((CCModel)((CCModel)modelMap.get("TStand")), (int)2);
        CCModel jstand = MultiIconTransformation.setIconIndex((CCModel)tstand.copy(), (int)1);
        CCModel rstand = MultiIconTransformation.setIconIndex((CCModel)((CCModel)modelMap.get("RStand")), (int)2);
        CCModel rdish = (CCModel)modelMap.get("RDish");
        RenderWireless.models[0][0] = tstand;
        RenderWireless.models[1][0] = CCModel.combine(Arrays.asList(rstand, rdish));
        RenderWireless.models[2][0] = jstand;
        int i = 0;
        while (i < 3) {
            models[i][0].computeNormals();
            ++i;
        }
        int j = 1;
        while (j < 24) {
            Transformation t = Rotation.sideOrientation((int)(j >> 2), (int)(j & 3)).at(Vector3.center);
            int i2 = 0;
            while (i2 < models.length) {
                RenderWireless.models[i2][j] = models[i2][0].copy().apply(t);
                ++i2;
            }
            ++j;
        }
        j = 0;
        while (j < 24) {
            int i3 = 0;
            while (i3 < 3) {
                models[i3][j].computeLighting(lm);
                ++i3;
            }
            ++j;
        }
    }

    public static void loadIcons(ly r) {
        lx base = TextureUtils.getIconFromTexture((String)"/mods/wrcbe_logic/textures/blocks/base.png", (ly)r);
        lx on = TextureUtils.getIconFromTexture((String)"/mods/wrcbe_logic/textures/blocks/on.png", (ly)r);
        lx off = TextureUtils.getIconFromTexture((String)"/mods/wrcbe_logic/textures/blocks/off.png", (ly)r);
        lx blaze = TextureUtils.getIconFromTexture((String)"/mods/wrcbe_logic/textures/blocks/blaze.png", (ly)r);
        lx obsidian = TextureUtils.getIconFromTexture((String)"/textures/blocks/obsidian.png", (ly)r);
        model_icont = new MultiIconTransformation(new lx[]{base, blaze, obsidian});
        RenderWireless.base_icont[0] = new MultiIconTransformation(new lx[]{base, off, base, base, base, base});
        RenderWireless.base_icont[1] = new MultiIconTransformation(new lx[]{base, on, base, base, base, base});
    }

    public static void renderInv(WirelessPart p) {
        CCRenderState.reset();
        CCRenderState.useNormals((boolean)true);
        CCRenderState.pullLightmap();
        CCRenderState.startDrawing((int)7);
        RenderUtils.renderBlock((Cuboid6)WirelessPart.baseBounds(0), (int)0, null, (IUVTransformation)base_icont[0], null);
        models[p.modelId()][0].render(null, (IUVTransformation)model_icont);
        CCRenderState.draw();
        RenderWireless.renderPearl(Vector3.zero, p);
    }

    public static void renderWorld(WirelessPart p) {
        CCRenderState.setBrightness((aak)p.world(), (int)p.x(), (int)p.y(), (int)p.z());
        Translation t = new Translation((double)p.x(), (double)p.y(), (double)p.z());
        RenderUtils.renderBlock((Cuboid6)p.baseRenderBounds, (int)p.baseRenderMask, (Transformation)p.rotationT().at(Vector3.center).with((Transformation)t), (IUVTransformation)base_icont[p.textureSet()], (IVertexModifier)rlm);
        models[p.modelId()][p.side() << 2 | p.rotation()].render((Transformation)t, (IUVTransformation)model_icont);
    }

    public static void renderFreq(Vector3 pos, TransceiverPart p) {
        GL11.glPushMatrix();
        pos.copy().add(Vector3.center).translation().glApply();
        p.rotationT().glApply();
        RenderWireless.renderFreq(p.getFreq());
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderWireless.renderFreq(p.getFreq());
        GL11.glPopMatrix();
    }

    private static void renderFreq(int freq) {
        float scale = 0.015625f;
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)-0.3125, (double)0.374);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        awv font = Minecraft.x().q;
        String s = Integer.toString(freq);
        GL11.glDepthMask((boolean)false);
        font.b(s, -font.a(s) / 2, 0, 0);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public static void renderPearl(Vector3 pos, WirelessPart p) {
        GL11.glPushMatrix();
        pos.translation().glApply();
        p.rotationT().at(Vector3.center).glApply();
        p.getPearlPos().translation().glApply();
        p.getPearlRotation().glApply();
        new Scale(p.getPearlScale()).glApply();
        if (p.tile() != null) {
            GL11.glRotatef((float)((float)(p.getPearlSpin() * 57.29577951308232)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        double light = p.active() ? 1.0 : 0.75;
        GL11.glDisable((int)2896);
        CCRenderState.reset();
        CCRenderState.changeTexture((String)"/codechicken/wirelessredstone/core/hedronmap.png");
        CCRenderState.pullLightmap();
        CCRenderState.setColour((int)new ColourRGBA(light, light, light, 1.0).rgba());
        CCRenderState.startDrawing((int)4);
        CCModelLibrary.icosahedron4.render();
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

