/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.utils.LabeledPositionedStack;
import net.minecraft.item.ItemStack;

public abstract class BaseProduceRecipeHandler
extends TemplateRecipeHandler {
    private final ISpeciesRoot speciesRoot;
    private final Map cache;

    public BaseProduceRecipeHandler(ISpeciesRoot root) {
        this.speciesRoot = root;
        this.cache = this.getProduceCache();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            return;
        }
        if (!outputId.equals(this.getRecipeIdent())) {
            return;
        }
        for (IAlleleSpecies species : this.getAllSpecies()) {
            CachedProduceRecipe rec = new CachedProduceRecipe(species);
            if (rec.isNoOutput()) continue;
            this.arecipes.add(rec);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!this.cache.containsKey(result.field_77993_c)) {
            return;
        }
        block0: for (IAlleleSpecies species : (Collection)this.cache.get(result.field_77993_c)) {
            CachedProduceRecipe recipe = new CachedProduceRecipe(species);
            for (LabeledPositionedStack stack : recipe.products) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)stack.item, (ItemStack)result)) continue;
                this.arecipes.add(recipe);
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!this.speciesRoot.isMember(ingredient)) {
            return;
        }
        this.arecipes.add(new CachedProduceRecipe(this.speciesRoot.getMember(ingredient).getGenome().getPrimary()));
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(48, 22, 21, 15), this.getRecipeIdent(), new Object[0]));
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        CachedProduceRecipe rec = (CachedProduceRecipe)((Object)this.arecipes.get(recipe));
        rec.producer.drawLabel(gui.window.field_73886_k);
        for (LabeledPositionedStack stack : rec.products) {
            stack.drawLabel(gui.window.field_73886_k);
        }
        gui.window.field_73886_k.func_78276_b("Prod:", 65, 12, 0xFFFFFF);
        gui.window.field_73886_k.func_78276_b("Spec:", 65, 40, 0xFFF200);
    }

    public abstract String getRecipeIdent();

    public abstract Collection getAllSpecies();

    public abstract Map getProduceCache();

    public String getGuiTexture() {
        return "/mods/neiaddons/textures/gui/products.png";
    }

    public class CachedProduceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private LabeledPositionedStack producer;
        private ArrayList products;

        public CachedProduceRecipe(IAlleleSpecies species) {
            String label;
            super((TemplateRecipeHandler)BaseProduceRecipeHandler.this);
            ItemStack producerStack = GeneticsUtils.stackFromSpecies(species, GeneticsUtils.RecipePosition.Producer);
            if (producerStack == null) {
                AddonForestry.instance.logWarning("Producer is null... wtf? species = %s", species.getUID());
            } else {
                this.producer = new LabeledPositionedStack(producerStack, 22, 19, species.getName(), 13);
            }
            this.products = new ArrayList();
            int i = 0;
            for (Map.Entry product : Utils.mergeStacks(GeneticsUtils.getProduceFromSpecies(species)).entrySet()) {
                label = String.format("%d%%", product.getValue());
                this.products.add(new LabeledPositionedStack(product.getKey(), 96 + 22 * i++, 8, label, 10));
            }
            i = 0;
            for (Map.Entry product : Utils.mergeStacks(GeneticsUtils.getSpecialtyFromSpecies(species)).entrySet()) {
                label = String.format("%d%%", product.getValue());
                this.products.add(new LabeledPositionedStack(product.getKey(), 96 + 22 * i++, 36, label, 10));
            }
        }

        public boolean isNoOutput() {
            return this.products.size() == 0;
        }

        public ArrayList getIngredients() {
            ArrayList<LabeledPositionedStack> list = new ArrayList<LabeledPositionedStack>();
            list.add(this.producer);
            return list;
        }

        public ArrayList getOtherStacks() {
            ArrayList list = new ArrayList();
            if (this.products.size() > 1) {
                for (int i = 1; i < this.products.size(); ++i) {
                    list.add(this.products.get(i));
                }
            }
            return list;
        }

        public PositionedStack getResult() {
            if (this.products.size() > 0) {
                return (PositionedStack)this.products.get(0);
            }
            return null;
        }
    }
}

