/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bdew.neiaddons.ServerHandler;
import net.bdew.neiaddons.api.NEIAddon;
import net.minecraftforge.common.Configuration;

@Mod(modid="NEIAddons", name="NEI Addons", version="1.8.2.r31", dependencies="after:NotEnoughItems")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class NEIAddons {
    public static Logger log;
    public static final String modid = "NEIAddons";
    public static final String channel = "bdew.neiaddons";
    public static List addons;
    public static Configuration config;

    public static void register(NEIAddon addon) {
        addons.add(addon);
    }

    public static void logInfo(String message, Object ... params) {
        log.log(Level.INFO, String.format(message, params));
    }

    public static void logWarning(String message, Object ... params) {
        log.log(Level.WARNING, String.format(message, params));
    }

    public static void logSevere(String message, Object ... params) {
        log.log(Level.SEVERE, String.format(message, params));
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.addCustomCategoryComment("Addons", "Controls loading of different addons, set to false to disable");
        addons = new ArrayList();
        if (event.getSide() == Side.CLIENT && !Loader.isModLoaded((String)"NotEnoughItems")) {
            NEIAddons.logSevere("NEI doesn't seem to be installed... NEI Addons require it to do anything useful client-side", new Object[0]);
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        NEIAddons.logInfo("Loading NEI Addons", new Object[0]);
        for (NEIAddon addon : addons) {
            if (config.get("Addons", addon.getName(), true).getBoolean(false)) {
                NEIAddons.logInfo("Loading %s Addon...", addon.getName());
                try {
                    addon.init(event.getSide());
                    if (!addon.isActive().booleanValue()) continue;
                    NEIAddons.logInfo("%s Addon successfully loadded", addon.getName());
                }
                catch (Exception e) {
                    NEIAddons.logSevere("Loading %s Addon - Failed:", addon.getName());
                    e.printStackTrace();
                }
                continue;
            }
            NEIAddons.logInfo("%s Addon disabled - skipping", addon.getName());
        }
        config.save();
        NetworkRegistry.instance().registerChannel((IPacketHandler)new ServerHandler(), channel, Side.SERVER);
        if (addons.size() > 0) {
            String addonslist = "Loaded Addons:";
            for (NEIAddon addon : addons) {
                addonslist = addonslist + "\n- " + addon.getName() + ": " + (addon.isActive() != false ? "Active" : "Inactive");
            }
            Loader.instance().activeModContainer().getMetadata().description = addonslist;
        } else {
            Loader.instance().activeModContainer().getMetadata().description = "No Addons loaded :(";
        }
    }
}

