/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class SimpleInventory
implements IInventory,
ISaveState {
    private ItemStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final HashMap _contentsMap;
    private final HashSet _contentsUndamagedSet;
    private final LinkedList _listener = new LinkedList();

    public SimpleInventory(int size, String name, int stackLimit) {
        this._contents = new ItemStack[size];
        this._name = name;
        this._stackLimit = stackLimit;
        this._contentsMap = new HashMap((int)((double)size * 1.5));
        this._contentsUndamagedSet = new HashSet((int)((double)size * 1.5));
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    public ItemStack func_70301_a(int i) {
        return this._contents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this._contents[i] == null) {
            return null;
        }
        if (this._contents[i].field_77994_a > j) {
            ItemStack ret = this._contents[i].func_77979_a(j);
            this.updateContents();
            return ret;
        }
        ItemStack ret = this._contents[i];
        this._contents[i] = null;
        this.updateContents();
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._contents[i] = itemstack;
        this.updateContents();
    }

    public String func_70303_b() {
        return this._name;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        this.updateContents();
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_74761_m(prefix + "items");
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index < this._contents.length) {
                this._contents[index] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
                continue;
            }
            LogisticsPipes.log.severe("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
        this.updateContents();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].field_77994_a <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this._contents[j].func_77955_b(nbttagcompound2);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World worldObj, int posX, int posY, int posZ) {
        if (MainProxy.isServer(worldObj)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].func_77976_d());
                    SimpleInventory.dropItems(worldObj, todrop, posX, posY, posZ);
                }
            }
            this.updateContents();
        }
    }

    private static void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_70293_c = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        if (this._listener.contains(listner)) {
            this._listener.remove(listner);
        }
    }

    public ItemStack func_70304_b(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        ItemStack stackToTake = this._contents[i];
        this._contents[i] = null;
        this.updateContents();
        return stackToTake;
    }

    public void handleItemIdentifierList(Collection _allItems) {
        int i = 0;
        for (ItemIdentifierStack stack : _allItems) {
            if (this._contents.length <= i) break;
            this._contents[i] = stack == null ? null : stack.unsafeMakeNormalStack();
            ++i;
        }
        this.func_70296_d();
    }

    private int tryAddToSlot(int i, ItemStack stack) {
        ItemIdentifier stackIdent;
        ItemStack slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = stack.func_77946_l();
            return stack.field_77994_a;
        }
        ItemIdentifier slotIdent = ItemIdentifier.get(slot);
        if (slotIdent.equals(stackIdent = ItemIdentifier.get(stack))) {
            slot.field_77994_a += stack.field_77994_a;
            if (slot.field_77994_a > this._stackLimit) {
                int ans = stack.field_77994_a - (slot.field_77994_a - this._stackLimit);
                slot.field_77994_a = this._stackLimit;
                return ans;
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    public int addCompressed(ItemStack stack) {
        int added;
        int i;
        if (stack == null) {
            return 0;
        }
        stack = stack.func_77946_l();
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            if (this._contents[i] == null) continue;
            added = this.tryAddToSlot(i, stack);
            stack.field_77994_a -= added;
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            added = this.tryAddToSlot(i, stack);
            stack.field_77994_a -= added;
        }
        this.func_70296_d();
        return stack.field_77994_a;
    }

    private void updateContents() {
        this._contentsMap.clear();
        this._contentsUndamagedSet.clear();
        for (int i = 0; i < this._contents.length; ++i) {
            ItemStack stack = this._contents[i];
            if (stack == null) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            Integer count = (Integer)this._contentsMap.get(itemId);
            if (count == null) {
                this._contentsMap.put(itemId, stack.field_77994_a);
            } else {
                this._contentsMap.put(itemId, (Integer)this._contentsMap.get(itemId) + stack.field_77994_a);
            }
            ItemIdentifier itemUndamagedId = ItemIdentifier.getUndamaged(stack);
            this._contentsUndamagedSet.add(itemUndamagedId);
        }
    }

    public int itemCount(ItemIdentifier item) {
        Integer i = (Integer)this._contentsMap.get(item);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Map getItemsAndCount() {
        return this._contentsMap;
    }

    public boolean containsItem(ItemIdentifier item) {
        return this._contentsMap.containsKey(item);
    }

    public boolean containsUndamagedItem(ItemIdentifier item) {
        return this._contentsUndamagedSet.contains(item);
    }

    public boolean isEmpty() {
        return this._contentsMap.isEmpty();
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

