/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public final class SidedInventoryForgeAdapter
implements IInventory {
    public final ISidedInventory _sidedInventory;
    private final int[] _slotMap;

    public SidedInventoryForgeAdapter(ISidedInventory sidedInventory, ForgeDirection side) {
        this._sidedInventory = sidedInventory;
        if (side == ForgeDirection.UNKNOWN) {
            this._slotMap = this.buildAllSidedMap(sidedInventory);
        } else {
            int nslots = this._sidedInventory.getSizeInventorySide(side);
            int offset = this._sidedInventory.getStartInventorySide(side);
            this._slotMap = new int[nslots];
            for (int i = 0; i < nslots; ++i) {
                this._slotMap[i] = i + offset;
            }
        }
    }

    private int[] buildAllSidedMap(ISidedInventory sidedInventory) {
        int j;
        int i;
        int[] invSizes = new int[6];
        int[] invStarts = new int[6];
        int nUnique = 0;
        block0: for (i = 0; i < 6; ++i) {
            ForgeDirection tside = ForgeDirection.VALID_DIRECTIONS[i];
            int size = sidedInventory.getSizeInventorySide(tside);
            if (size == 0) continue;
            int start = sidedInventory.getStartInventorySide(tside);
            for (j = 0; j < nUnique; ++j) {
                if (invStarts[j] == start && invSizes[j] == size) continue block0;
            }
            invStarts[nUnique] = start;
            invSizes[nUnique] = size;
            ++nUnique;
        }
        for (i = 0; i < nUnique; ++i) {
            int best = i;
            for (int j2 = i + 1; j2 < nUnique; ++j2) {
                if (invStarts[j2] < invStarts[best]) {
                    best = j2;
                    continue;
                }
                if (invStarts[j2] != invStarts[best] || invSizes[j2] <= invSizes[best]) continue;
                best = j2;
            }
            if (best == i) continue;
            int tstart = invStarts[i];
            int tsize = invSizes[i];
            invStarts[i] = invStarts[best];
            invSizes[i] = invSizes[best];
            invStarts[best] = tstart;
            invSizes[best] = tsize;
        }
        for (i = 0; i < nUnique; ++i) {
            if (invSizes[i] == 0) continue;
            for (int j3 = i + 1; j3 < nUnique; ++j3) {
                if (invSizes[j3] == 0) continue;
                if (invStarts[j3] + invSizes[j3] <= invStarts[i] + invSizes[i]) {
                    invSizes[j3] = 0;
                    continue;
                }
                if (invStarts[j3] > invStarts[i] + invSizes[i] || invStarts[j3] + invSizes[j3] < invStarts[i] + invSizes[i]) continue;
                invSizes[i] = invStarts[j3] - invStarts[i] + invSizes[j3];
                invSizes[j3] = 0;
            }
        }
        int totalslots = 0;
        for (int i2 = 0; i2 < nUnique; ++i2) {
            totalslots += invSizes[i2];
        }
        int[] slotmap = new int[totalslots];
        int curidx = 0;
        for (int i3 = 0; i3 < nUnique; ++i3) {
            j = invStarts[i3];
            while (j < invStarts[i3] + invSizes[i3]) {
                slotmap[curidx++] = j++;
            }
        }
        return slotmap;
    }

    public int func_70302_i_() {
        return this._slotMap.length;
    }

    public ItemStack func_70301_a(int i) {
        return this._sidedInventory.func_70301_a(this._slotMap[i]);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this._sidedInventory.func_70298_a(this._slotMap[i], j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._sidedInventory.func_70299_a(this._slotMap[i], itemstack);
    }

    public String func_70303_b() {
        return this._sidedInventory.func_70303_b();
    }

    public int func_70297_j_() {
        return this._sidedInventory.func_70297_j_();
    }

    public void func_70296_d() {
        this._sidedInventory.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this._sidedInventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this._sidedInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this._sidedInventory.func_70305_f();
    }

    public ItemStack func_70304_b(int slot) {
        return this._sidedInventory.func_70304_b(this._slotMap[slot]);
    }

    public boolean func_94042_c() {
        return this._sidedInventory.func_94042_c();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this._sidedInventory.func_94041_b(this._slotMap[i], itemstack);
    }
}

