/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.com.google.common.base.Objects;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidIdentifier {
    private static final ConcurrentHashMap _liquidIdentifierCache = new ConcurrentHashMap();
    private static final ConcurrentSkipListSet _liquidIdentifierKeyQueue = new ConcurrentSkipListSet();
    public final int itemId;
    public final int itemMeta;
    public final String name;
    private static boolean init = false;

    private LiquidIdentifier(int itemId, int itemMeta, String name) {
        this.itemId = itemId;
        this.itemMeta = itemMeta;
        if (name == null) {
            name = "";
        }
        this.name = name;
        ItemKey key = new ItemKey(itemId, itemMeta);
        _liquidIdentifierCache.put(key, this);
        if (this.isVaild()) {
            _liquidIdentifierKeyQueue.add(key);
        }
    }

    public String getName() {
        return this.name;
    }

    public ItemIdentifier getItemIdentifier() {
        return ItemIdentifier.get(this.itemId, this.itemMeta, null);
    }

    public static LiquidIdentifier get(LiquidStack stack) {
        if (stack.extra != null) {
            LogisticsPipes.log.warning("Found liquidStack with NBT tag. LP doesn't know how to handle it.");
            new Exception().printStackTrace();
        }
        return LiquidIdentifier.get(stack.itemID, stack.itemMeta);
    }

    public static LiquidIdentifier get(LiquidStack stack, String name) {
        if (stack.extra != null) {
            LogisticsPipes.log.warning("Found liquidStack with NBT tag. LP doesn't know how to handle it.");
            new Exception().printStackTrace();
        }
        return LiquidIdentifier.get(stack.itemID, stack.itemMeta, name);
    }

    public static LiquidIdentifier get(int itemID, int itemMeta) {
        return LiquidIdentifier.get(itemID, itemMeta, "");
    }

    public static LiquidIdentifier get(int itemID, int itemMeta, String name) {
        if (_liquidIdentifierCache.containsKey(new ItemKey(itemID, itemMeta))) {
            return (LiquidIdentifier)_liquidIdentifierCache.get(new ItemKey(itemID, itemMeta));
        }
        return new LiquidIdentifier(itemID, itemMeta, name);
    }

    public LiquidStack makeLiquidStack(int amount) {
        return new LiquidStack(this.itemId, amount, this.itemMeta);
    }

    public int getFreeSpaceInsideTank(ITankContainer container, ForgeDirection dir) {
        int free = 0;
        ILiquidTank[] tanks = container.getTanks(dir);
        if (tanks != null && tanks.length > 0) {
            for (int i = 0; i < tanks.length; ++i) {
                free += this.getFreeSpaceInsideTank(tanks[i]);
            }
        } else {
            ILiquidTank tank = container.getTank(dir, this.makeLiquidStack(0));
            if (tank != null) {
                free += this.getFreeSpaceInsideTank(tank);
            }
        }
        return free;
    }

    public int getFreeSpaceInsideTank(ILiquidTank tank) {
        LiquidStack liquid = tank.getLiquid();
        if (liquid == null || liquid.itemID <= 0) {
            return tank.getCapacity();
        }
        if (LiquidIdentifier.get(liquid) == this) {
            return tank.getCapacity() - liquid.amount;
        }
        return 0;
    }

    public static void initFromForge(boolean flag) {
        if (init) {
            return;
        }
        Map liquids = LiquidDictionary.getLiquids();
        for (Map.Entry name : liquids.entrySet()) {
            LiquidIdentifier.get((LiquidStack)name.getValue(), (String)name.getKey());
        }
        if (flag) {
            init = true;
        }
    }

    public String toString() {
        return this.name + "/" + this.itemId + ":" + this.itemMeta;
    }

    public boolean isVaild() {
        return Item.field_77698_e.length > this.itemId && Item.field_77698_e[this.itemId] != null;
    }

    public LiquidIdentifier next() {
        ItemKey key = new ItemKey(this.itemId, this.itemMeta);
        if (!_liquidIdentifierKeyQueue.contains(key)) {
            return LiquidIdentifier.first();
        }
        if ((key = _liquidIdentifierKeyQueue.higher(key)) == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public LiquidIdentifier prev() {
        ItemKey key = new ItemKey(this.itemId, this.itemMeta);
        if (!_liquidIdentifierKeyQueue.contains(key)) {
            return LiquidIdentifier.last();
        }
        if ((key = _liquidIdentifierKeyQueue.lower(key)) == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public static LiquidIdentifier first() {
        ItemKey key = (ItemKey)_liquidIdentifierKeyQueue.first();
        if (key == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public static LiquidIdentifier last() {
        ItemKey key = (ItemKey)_liquidIdentifierKeyQueue.last();
        if (key == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    private static class ItemKey
    implements Comparable {
        public int itemID;
        public int itemDamage;

        public ItemKey(int id, int d) {
            this.itemID = id;
            this.itemDamage = d;
        }

        public boolean equals(Object that) {
            if (!(that instanceof ItemKey)) {
                return false;
            }
            ItemKey i = (ItemKey)that;
            return this.itemID == i.itemID && this.itemDamage == i.itemDamage;
        }

        public int hashCode() {
            return Objects.hashCode(this.itemID, this.itemDamage);
        }

        public int compareTo(ItemKey o) {
            if (this.itemID == o.itemID) {
                return this.itemDamage - o.itemDamage;
            }
            return this.itemID - o.itemID;
        }
    }
}

