/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemIdentifierStack
implements Comparable {
    private final ItemIdentifier _item;
    public int stackSize;

    public static ItemIdentifierStack GetFromStack(ItemStack stack) {
        return new ItemIdentifierStack(ItemIdentifier.get(stack), stack.field_77994_a);
    }

    public ItemIdentifierStack(ItemIdentifier item, int stackSize) {
        this._item = item;
        this.stackSize = stackSize;
    }

    public ItemIdentifier getItem() {
        return this._item;
    }

    public ItemStack unsafeMakeNormalStack() {
        ItemStack stack = new ItemStack(this._item.itemID, this.stackSize, this._item.itemDamage);
        stack.func_77982_d((NBTTagCompound)this._item.tag);
        return stack;
    }

    public ItemStack makeNormalStack() {
        ItemStack stack = new ItemStack(this._item.itemID, this.stackSize, this._item.itemDamage);
        if (this._item.tag != null) {
            stack.func_77982_d((NBTTagCompound)this._item.tag.func_74737_b());
        }
        return stack;
    }

    public boolean equals(Object object) {
        if (object instanceof ItemIdentifierStack) {
            ItemIdentifierStack stack = (ItemIdentifierStack)object;
            return stack._item.equals(this._item) && stack.stackSize == this.stackSize;
        }
        return false;
    }

    public int hashCode() {
        return this._item.hashCode() ^ 1023 * this.stackSize;
    }

    public String toString() {
        return Integer.toString(this.stackSize) + "x" + this._item.toString();
    }

    public ItemIdentifierStack clone() {
        return new ItemIdentifierStack(this._item, this.stackSize);
    }

    public String getFriendlyName() {
        return this.stackSize + " " + this._item.getFriendlyName();
    }

    public void write(DataOutputStream data) throws IOException {
        data.writeInt(this._item.itemID);
        data.writeInt(this.stackSize);
        data.writeInt(this._item.itemDamage);
        SendNBTTagCompound.writeNBTTagCompound(this._item.tag, data);
    }

    public static ItemIdentifierStack read(DataInputStream data) throws IOException {
        int itemID = data.readInt();
        int stacksize = data.readInt();
        int damage = data.readInt();
        NBTTagCompound tag = SendNBTTagCompound.readNBTTagCompound(data);
        return new ItemIdentifierStack(ItemIdentifier.get(itemID, damage, tag), stacksize);
    }

    public static LinkedList getListFromInventory(IInventory inv) {
        return ItemIdentifierStack.getListFromInventory(inv, false);
    }

    public static LinkedList getListFromInventory(IInventory inv, boolean removeNull) {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) {
                if (removeNull) continue;
                list.add(null);
                continue;
            }
            list.add(ItemIdentifierStack.GetFromStack(inv.func_70301_a(i)));
        }
        return list;
    }

    public static LinkedList getListSendQueue(LinkedList _sendQueue) {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        for (Pair3 part : _sendQueue) {
            if (part == null) {
                list.add(null);
                continue;
            }
            boolean added = false;
            for (ItemIdentifierStack stack : list) {
                if (!stack.getItem().equals(ItemIdentifierStack.GetFromStack(((IRoutedItem)part.getValue1()).getItemStack()).getItem())) continue;
                stack.stackSize += ((IRoutedItem)part.getValue1()).getItemStack().field_77994_a;
                added = true;
                break;
            }
            if (added) continue;
            list.add(ItemIdentifierStack.GetFromStack(((IRoutedItem)part.getValue1()).getItemStack()));
        }
        return list;
    }

    public int compareTo(ItemIdentifierStack o) {
        int c = this._item.compareTo(o._item);
        if (c == 0) {
            return this.stackSize - o.stackSize;
        }
        return c;
    }

    public static class simpleItemComparitor
    implements Comparator {
        public int compare(ItemIdentifierStack o1, ItemIdentifierStack o2) {
            int c = ((ItemIdentifierStack)o1)._item.itemID - ((ItemIdentifierStack)o2)._item.itemID;
            if (c != 0) {
                return c;
            }
            return ((ItemIdentifierStack)o1)._item.itemDamage - ((ItemIdentifierStack)o2)._item.itemDamage;
        }
    }

    public static class itemComparitor
    implements Comparator {
        public int compare(ItemIdentifierStack o1, ItemIdentifierStack o2) {
            int c = ((ItemIdentifierStack)o1)._item.itemID - ((ItemIdentifierStack)o2)._item.itemID;
            if (c != 0) {
                return c;
            }
            c = ((ItemIdentifierStack)o1)._item.itemDamage - ((ItemIdentifierStack)o2)._item.itemDamage;
            if (c != 0) {
                return c;
            }
            return ((ItemIdentifierStack)o1)._item.uniqueID - ((ItemIdentifierStack)o2)._item.uniqueID;
        }
    }

    public static class orderedComparitor
    implements Comparator {
        public int compare(ItemIdentifierStack o1, ItemIdentifierStack o2) {
            int c = ((ItemIdentifierStack)o1)._item.itemID - ((ItemIdentifierStack)o2)._item.itemID;
            if (c != 0) {
                return c;
            }
            c = ((ItemIdentifierStack)o1)._item.itemDamage - ((ItemIdentifierStack)o2)._item.itemDamage;
            if (c != 0) {
                return c;
            }
            c = ((ItemIdentifierStack)o1)._item.uniqueID - ((ItemIdentifierStack)o2)._item.uniqueID;
            if (c != 0) {
                return c;
            }
            return o2.stackSize - o1.stackSize;
        }
    }
}

