/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.ObfuscationHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class ItemIdentifier
implements Comparable {
    private static final ConcurrentHashMap _itemIdentifierIdCache = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final ConcurrentHashMap _itemIdentifierTagCache = new ConcurrentHashMap(1024, 0.5f, 1);
    private static final ConcurrentHashMap _itemIdentifierCache = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final ArrayList _modNameList = new ArrayList();
    private static final Map _modNameToModIdMap = new HashMap();
    private static final int[] _modItemIdMap = new int[32768];
    private static boolean init = false;
    public final int itemID;
    public final int itemDamage;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private ItemIdentifier _IDIgnoringNBT = null;
    private ItemIdentifier _IDIgnoringDamage = null;
    public static boolean allowNullsForTesting;

    private ItemIdentifier(int itemID, int itemDamage, FinalNBTTagCompound tag, int uniqueID) {
        this.itemID = itemID;
        this.itemDamage = itemDamage;
        this.tag = tag;
        this.uniqueID = uniqueID;
    }

    public static ItemIdentifier get(int itemID, int itemUndamagableDamage, NBTTagCompound tag) {
        ItemKey itemKey = new ItemKey(itemID, itemUndamagableDamage);
        if (tag == null) {
            ItemIdentifier unknownItem = (ItemIdentifier)_itemIdentifierCache.get(itemKey);
            if (unknownItem != null) {
                return unknownItem;
            }
            int id = ItemIdentifier.getUnusedId();
            unknownItem = new ItemIdentifier(itemID, itemUndamagableDamage, null, id);
            _itemIdentifierCache.put(itemKey, unknownItem);
            _itemIdentifierIdCache.put(id, unknownItem);
            return unknownItem;
        }
        ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier> itemNBTList = (ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier>)_itemIdentifierTagCache.get(itemKey);
        FinalNBTTagCompound tagwithfixedname = new FinalNBTTagCompound(tag);
        if (itemNBTList != null) {
            ItemIdentifier unknownItem = (ItemIdentifier)itemNBTList.get((Object)tagwithfixedname);
            if (unknownItem != null) {
                return unknownItem;
            }
        } else {
            itemNBTList = new ConcurrentHashMap<FinalNBTTagCompound, ItemIdentifier>(16, 0.5f, 1);
            _itemIdentifierTagCache.put(itemKey, itemNBTList);
        }
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound((NBTTagCompound)tag.func_74737_b());
        ItemIdentifier unknownItem = new ItemIdentifier(itemID, itemUndamagableDamage, finaltag, ItemIdentifier.getUnusedId());
        ItemIdentifier.checkNBTbadness(unknownItem, (NBTBase)tag);
        itemNBTList.put(finaltag, unknownItem);
        _itemIdentifierIdCache.put(unknownItem.uniqueID, unknownItem);
        return unknownItem;
    }

    public static ItemIdentifier get(ItemStack itemStack) {
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        return ItemIdentifier.get(itemStack.field_77993_c, itemStack.func_77960_j(), itemStack.field_77990_d);
    }

    public static ItemIdentifier getUndamaged(ItemStack itemStack) {
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        int itemDamage = 0;
        if (!Item.field_77698_e[itemStack.field_77993_c].func_77645_m()) {
            itemDamage = itemStack.func_77960_j();
        }
        return ItemIdentifier.get(itemStack.field_77993_c, itemDamage, itemStack.field_77990_d);
    }

    public ItemIdentifier getUndamaged() {
        if (this._IDIgnoringDamage == null) {
            this._IDIgnoringDamage = !Item.field_77698_e[this.itemID].func_77645_m() ? this : ItemIdentifier.get(this.itemID, 0, this.tag);
        }
        return this._IDIgnoringDamage;
    }

    public static ItemIdentifier getIgnoringNBT(ItemStack itemStack) {
        return ItemIdentifier.get(itemStack.field_77993_c, itemStack.func_77960_j(), null);
    }

    public ItemIdentifier getIgnoringNBT() {
        if (this._IDIgnoringNBT == null) {
            this._IDIgnoringNBT = ItemIdentifier.get(this.itemID, this.itemDamage, null);
        }
        return this._IDIgnoringNBT;
    }

    public static ItemIdentifier getForId(int id) {
        return (ItemIdentifier)_itemIdentifierIdCache.get(id);
    }

    private static int getUnusedId() {
        int id = new Random().nextInt();
        while (ItemIdentifier.isIdUsed(id)) {
            id = new Random().nextInt();
        }
        return id;
    }

    private static boolean isIdUsed(int id) {
        return _itemIdentifierIdCache.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        if (init) {
            return;
        }
        int[] nArray = _modItemIdMap;
        synchronized (_modItemIdMap) {
            if (init) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            init = true;
            _modNameToModIdMap.put("UNKNOWN", 0);
            _modNameList.add("UNKNOWN");
            NBTTagList list = new NBTTagList();
            GameData.writeItemData((NBTTagList)list);
            Set set = GameData.buildWorldItemData((NBTTagList)list);
            for (ItemData data : set) {
                String modname = data.getModId();
                if (modname == null) continue;
                Integer modid = (Integer)_modNameToModIdMap.get(modname);
                if (modid == null) {
                    modid = _modNameList.size();
                    _modNameList.add(modname);
                    _modNameToModIdMap.put(modname, modid);
                }
                ItemIdentifier._modItemIdMap[data.getItemId()] = modid;
            }
            _modNameList.ensureCapacity(_modNameToModIdMap.size());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public String getDebugName() {
        if (Item.field_77698_e[this.itemID] != null) {
            return Item.field_77698_e[this.itemID].func_77658_a() + "(ID: " + this.itemID + ", Damage: " + this.itemDamage + ")";
        }
        return "<item not found>";
    }

    public boolean isValid() {
        return Item.field_77698_e[this.itemID] != null;
    }

    private String getName(int id, ItemStack stack) {
        String name = "???";
        try {
            name = Item.field_77698_e[id].func_77628_j(stack);
            if (name == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                name = Item.field_77698_e[id].func_77667_c(stack);
                if (name == null) {
                    throw new Exception();
                }
            }
            catch (Exception e1) {
                try {
                    name = Item.field_77698_e[id].func_77658_a();
                    if (name == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    name = "???";
                }
            }
        }
        return name;
    }

    public String getFriendlyName() {
        if (Item.field_77698_e[this.itemID] != null) {
            return this.getName(this.itemID, this.unsafeMakeNormalStack(1));
        }
        return "<Item name not found>";
    }

    public String getFriendlyNameCC() {
        if (Item.field_77698_e[this.itemID] != null) {
            return MainProxy.proxy.getName(this);
        }
        return "<Item name not found>";
    }

    public int getModId() {
        return _modItemIdMap[this.itemID];
    }

    public String getModName() {
        return (String)_modNameList.get(_modItemIdMap[this.itemID]);
    }

    public static int getModIdForName(String modname) {
        Integer m = (Integer)_modNameToModIdMap.get(modname);
        if (m == null) {
            return 0;
        }
        return m;
    }

    public ItemIdentifierStack makeStack(int stackSize) {
        return new ItemIdentifierStack(this, stackSize);
    }

    public ItemStack unsafeMakeNormalStack(int stackSize) {
        ItemStack stack = new ItemStack(this.itemID, stackSize, this.itemDamage);
        stack.func_77982_d((NBTTagCompound)this.tag);
        return stack;
    }

    public ItemStack makeNormalStack(int stackSize) {
        ItemStack stack = new ItemStack(this.itemID, stackSize, this.itemDamage);
        if (this.tag != null) {
            stack.func_77982_d((NBTTagCompound)this.tag.func_74737_b());
        }
        return stack;
    }

    public int getMaxStackSize() {
        if (Item.field_77698_e[this.itemID].func_77645_m() && this.itemDamage > 0) {
            return 1;
        }
        int limit = Item.field_77698_e[this.itemID].func_77639_j();
        return limit < 64 ? limit : 64;
    }

    public boolean fuzzyMatch(ItemStack stack) {
        if (stack.field_77993_c != this.itemID) {
            return false;
        }
        return stack.func_77960_j() == this.itemDamage;
    }

    public int getId() {
        return this.uniqueID;
    }

    public String getNBTTagCompoundName() {
        if (this.tag != null) {
            return this.tag.func_74740_e();
        }
        return null;
    }

    public Map getNBTTagCompoundAsMap() {
        if (this.tag != null) {
            try {
                return this.getNBTBaseAsMap((NBTBase)this.tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Map getArrayAsMap(int[] array) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        for (int object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    private Map getArrayAsMap(byte[] array) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        int i = 1;
        for (byte object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    private Map getNBTBaseAsMap(NBTBase nbt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagByte) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagByte");
            map.put("value", ((NBTTagByte)nbt).field_74756_a);
            return map;
        }
        if (nbt instanceof NBTTagByteArray) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagByteArray");
            map.put("value", this.getArrayAsMap(((NBTTagByteArray)nbt).field_74754_a));
            return map;
        }
        if (nbt instanceof NBTTagDouble) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagDouble");
            map.put("value", ((NBTTagDouble)nbt).field_74755_a);
            return map;
        }
        if (nbt instanceof NBTTagFloat) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagFloat");
            map.put("value", Float.valueOf(((NBTTagFloat)nbt).field_74750_a));
            return map;
        }
        if (nbt instanceof NBTTagInt) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagInt");
            map.put("value", ((NBTTagInt)nbt).field_74748_a);
            return map;
        }
        if (nbt instanceof NBTTagIntArray) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagIntArray");
            map.put("value", this.getArrayAsMap(((NBTTagIntArray)nbt).field_74749_a));
            return map;
        }
        if (nbt instanceof NBTTagList) {
            Field fList = ObfuscationHelper.getDeclaredField(ObfuscationHelper.NAMES.tagList, new Class[0]);
            fList.setAccessible(true);
            List internal = (List)fList.get(nbt);
            HashMap<Integer, Map> content = new HashMap<Integer, Map>();
            int i = 1;
            for (Object object : internal) {
                if (object instanceof NBTBase) {
                    content.put(i, this.getNBTBaseAsMap((NBTBase)object));
                }
                ++i;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagList");
            map.put("value", content);
            return map;
        }
        if (nbt instanceof NBTTagCompound) {
            HashMap internal = new HashMap();
            Field fMap = ObfuscationHelper.getDeclaredField(ObfuscationHelper.NAMES.tagMap, new Class[0]);
            fMap.setAccessible(true);
            internal = (HashMap)fMap.get(nbt);
            HashMap content = new HashMap();
            HashMap keys = new HashMap();
            int i = 1;
            for (Map.Entry object : internal.entrySet()) {
                Map.Entry e = object;
                if (e.getValue() instanceof NBTBase) {
                    content.put(e.getKey(), this.getNBTBaseAsMap((NBTBase)e.getValue()));
                    keys.put(i, e.getKey());
                }
                ++i;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagCompound");
            map.put("value", content);
            map.put("keys", keys);
            return map;
        }
        if (nbt instanceof NBTTagLong) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagLong");
            map.put("value", ((NBTTagLong)nbt).field_74753_a);
            return map;
        }
        if (nbt instanceof NBTTagShort) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagShort");
            map.put("value", ((NBTTagShort)nbt).field_74752_a);
            return map;
        }
        if (nbt instanceof NBTTagString) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", nbt.func_74740_e());
            map.put("type", "NBTTagString");
            map.put("value", ((NBTTagString)nbt).field_74751_a);
            return map;
        }
        throw new UnsupportedOperationException("Unsupported NBTBase of type:" + nbt.getClass().getName());
    }

    public String toString() {
        return this.getModName() + "(" + this.getModId() + "):" + this.getFriendlyName();
    }

    public int compareTo(ItemIdentifier o) {
        if (this.uniqueID < o.uniqueID) {
            return -1;
        }
        if (this.uniqueID > o.uniqueID) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (!(that instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier i = (ItemIdentifier)that;
        return this.uniqueID == i.uniqueID;
    }

    public int hashCode() {
        return this.uniqueID;
    }

    public LiquidIdentifier getLiquidIdentifier() {
        return LiquidIdentifier.get(this.itemID, this.itemDamage);
    }

    public boolean equalsForCrafting(ItemIdentifier item) {
        return this.itemID == item.itemID && (item.isDamagable() || this.itemDamage == item.itemDamage);
    }

    public boolean equalsWithoutNBT(ItemIdentifier item) {
        return this.itemID == item.itemID && this.itemDamage == item.itemDamage;
    }

    public boolean isDamagable() {
        return this.makeNormalStack(0).func_77973_b().func_77645_m();
    }

    private static void checkNBTbadness(ItemIdentifier item, NBTBase nbt) {
        if ((item.getMaxStackSize() > 1 || LogisticsPipes.DEBUG) && nbt.func_74740_e() == "") {
            LogisticsPipes.log.warning("Bad item " + item.getDebugName() + " : Root NBTTag has no name");
        }
        try {
            String s = ItemIdentifier.checkNBTbadness_recurse(nbt);
            if (s != null) {
                LogisticsPipes.log.warning("Bad item " + item.getDebugName() + " : " + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String checkNBTbadness_recurse(NBTBase nbt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        block6: {
            block5: {
                if (!(nbt instanceof NBTTagList)) break block5;
                NBTTagList l = (NBTTagList)nbt;
                for (int i = 0; i < l.func_74745_c(); ++i) {
                    NBTBase b = l.func_74743_b(i);
                    if (!b.func_74740_e().equals("")) {
                        return "NBTTagList containing named tag " + b.func_74740_e();
                    }
                    String ret = ItemIdentifier.checkNBTbadness_recurse(b);
                    if (ret == null) continue;
                    return ret;
                }
                break block6;
            }
            if (!(nbt instanceof NBTTagCompound)) break block6;
            Field fMap = ObfuscationHelper.getDeclaredField(ObfuscationHelper.NAMES.tagMap, new Class[0]);
            fMap.setAccessible(true);
            Map internal = (Map)fMap.get(nbt);
            for (Map.Entry e : internal.entrySet()) {
                String k = (String)e.getKey();
                NBTBase v = (NBTBase)e.getValue();
                if (k == null || k.equals("")) {
                    return "NBTTagCompound containing empty key";
                }
                if (!k.equals(v.func_74740_e())) {
                    return "NBTTagCompound key " + k + " doesn't match value name " + v;
                }
                String ret = ItemIdentifier.checkNBTbadness_recurse(v);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    private static class ItemKey
    implements Comparable {
        public final int itemID;
        public final int itemDamage;

        public ItemKey(int id, int d) {
            this.itemID = id;
            this.itemDamage = d;
        }

        public boolean equals(Object that) {
            if (!(that instanceof ItemKey)) {
                return false;
            }
            ItemKey i = (ItemKey)that;
            return this.itemID == i.itemID && this.itemDamage == i.itemDamage;
        }

        public int hashCode() {
            return this.itemID * 1000001 + this.itemDamage;
        }

        public int compareTo(ItemKey o) {
            if (this.itemID == o.itemID) {
                return this.itemDamage - o.itemDamage;
            }
            return this.itemID - o.itemID;
        }
    }
}

