/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.FuzzyInventoryUtil;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.InventoryUtil;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;

public class InventoryUtilFactory {
    private final List handler = new ArrayList();

    public void registerHandler(SpecialInventoryHandler invHandler) {
        if (invHandler.init()) {
            this.handler.add(invHandler);
            LogisticsPipes.log.info("Loaded SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        } else {
            LogisticsPipes.log.warning("Could not load SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        }
    }

    private TileEntity getTileEntityFromInventory(IInventory inv) {
        if (inv instanceof TileEntity) {
            return (TileEntity)inv;
        }
        if (inv instanceof SidedInventoryForgeAdapter) {
            if (((SidedInventoryForgeAdapter)inv)._sidedInventory instanceof TileEntity) {
                return (TileEntity)((SidedInventoryForgeAdapter)inv)._sidedInventory;
            }
        } else if (inv instanceof SidedInventoryMinecraftAdapter && ((SidedInventoryMinecraftAdapter)inv)._sidedInventory instanceof TileEntity) {
            return (TileEntity)((SidedInventoryMinecraftAdapter)inv)._sidedInventory;
        }
        return null;
    }

    public SpecialInventoryHandler getUtilForInv(IInventory inv, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        TileEntity tile = this.getTileEntityFromInventory(inv);
        if (tile == null) {
            return null;
        }
        for (SpecialInventoryHandler invHandler : this.handler) {
            if (!invHandler.isType(tile)) continue;
            return invHandler.getUtilForTile(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return null;
    }

    public IInventoryUtil getInventoryUtil(IInventory inv) {
        return this.getHidingInventoryUtil(inv, false, false, 0, 0);
    }

    public IInventoryUtil getHidingInventoryUtil(IInventory inv, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IInventoryUtil util = this.getUtilForInv(inv, hideOnePerStack, hideOne, cropStart, cropEnd);
        if (util == null) {
            util = new InventoryUtil(InventoryHelper.getInventory(inv), hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return util;
    }

    public IInventoryUtil getFuzzyInventoryUtil(IInventory inv) {
        return new FuzzyInventoryUtil(inv);
    }
}

