/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.utils.Utils;
import java.util.BitSet;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeLiquidUpdate;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidSection;
import logisticspipes.proxy.MainProxy;
import logisticspipes.transport.PipeTransportLogistics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidTransportLogistics
extends PipeTransportLogistics
implements ITankContainer {
    public LogisticsLiquidSection[] sideTanks = new LogisticsLiquidSection[ForgeDirection.VALID_DIRECTIONS.length];
    public LogisticsLiquidSection internalTank = new LogisticsLiquidSection(this.getInnerCapacity());
    public LiquidStack[] renderCache = new LiquidStack[7];
    private final SafeTimeTracker tracker = new SafeTimeTracker();
    private long clientSyncCounter = BuildCraftCore.longUpdateFactor - 10L;
    public byte initClient = 0;
    private static final ForgeDirection[] orientations = ForgeDirection.values();

    public PipeLiquidTransportLogistics() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sideTanks[dir.ordinal()] = new LogisticsLiquidSection(this.getSideCapacity());
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from.ordinal() < ForgeDirection.VALID_DIRECTIONS.length) {
            return this.sideTanks[from.ordinal()].fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.getOrientation((int)tankIndex), resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.ordinal() < ForgeDirection.VALID_DIRECTIONS.length) {
            return this.sideTanks[from.ordinal()].drain(maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.getOrientation((int)tankIndex), maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction.ordinal() < ForgeDirection.VALID_DIRECTIONS.length) {
            return new ILiquidTank[]{this.sideTanks[direction.ordinal()]};
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!nbttagcompound.func_74764_b("tank[" + direction.ordinal() + "]")) continue;
            this.sideTanks[direction.ordinal()].readFromNBT(nbttagcompound.func_74775_l("tank[" + direction.ordinal() + "]"));
        }
        if (nbttagcompound.func_74764_b("tank[middle]")) {
            this.internalTank.readFromNBT(nbttagcompound.func_74775_l("tank[middle]"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.sideTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.func_74782_a("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
        }
        NBTTagCompound subTag = new NBTTagCompound();
        this.internalTank.writeToNBT(subTag);
        nbttagcompound.func_74782_a("tank[middle]", (NBTBase)subTag);
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }

    public int getInnerCapacity() {
        return 10000;
    }

    public int getSideCapacity() {
        return 5000;
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            LiquidStack stack;
            if (Utils.checkPipesConnections((TileEntity)this.container.getTile(orientations[direction.ordinal()]), (TileEntity)this.container)) continue;
            if (MainProxy.isServer(this.worldObj) && (stack = this.sideTanks[direction.ordinal()].getLiquid()) != null) {
                this.sideTanks[direction.ordinal()].setLiquid(null);
                this.internalTank.fill(stack, true);
            }
            if (this.renderCache[direction.ordinal()] == null) continue;
            this.renderCache[direction.ordinal()].amount = 1;
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.updateLiquid();
    }

    private void updateLiquid() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        if (this.tracker.markTimeIfDelay(this.worldObj, (long)BuildCraftCore.updateFactor)) {
            ModernPacket packet;
            boolean init = false;
            if (++this.clientSyncCounter > BuildCraftCore.longUpdateFactor) {
                this.clientSyncCounter = 0L;
                init = true;
            }
            if (this.clientSyncCounter < 0L) {
                this.clientSyncCounter = 0L;
            }
            if ((packet = this.computeLiquidUpdate(init, true)) != null) {
                MainProxy.sendPacketToAllWatchingChunk(this.xCoord, this.zCoord, MainProxy.getDimensionForWorld(this.worldObj), packet);
            }
        }
    }

    private ModernPacket computeLiquidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        BitSet delta = new BitSet(21);
        if (this.initClient > 0) {
            this.initClient = (byte)(this.initClient - 1);
            if (this.initClient == 1) {
                changed = true;
                delta.set(0, 21);
            }
        }
        LiquidStack[] renderCache = (LiquidStack[])this.renderCache.clone();
        for (ForgeDirection dir : orientations) {
            int displayQty;
            LiquidStack current = dir != ForgeDirection.UNKNOWN ? this.sideTanks[dir.ordinal()].getLiquid() : this.internalTank.getLiquid();
            LiquidStack prev = renderCache[dir.ordinal()];
            if (prev == null && current == null) continue;
            if (prev == null && current != null) {
                changed = true;
                renderCache[dir.ordinal()] = current.copy();
                delta.set(dir.ordinal() * 3 + 0);
                delta.set(dir.ordinal() * 3 + 1);
                delta.set(dir.ordinal() * 3 + 2);
                continue;
            }
            if (prev != null && current == null) {
                changed = true;
                renderCache[dir.ordinal()] = null;
                delta.set(dir.ordinal() * 3 + 0);
                delta.set(dir.ordinal() * 3 + 1);
                delta.set(dir.ordinal() * 3 + 2);
                continue;
            }
            if (prev.itemID != current.itemID || initPacket) {
                changed = true;
                renderCache[dir.ordinal()] = new LiquidStack(current.itemID, renderCache[dir.ordinal()].amount);
                delta.set(dir.ordinal() * 3 + 0);
            }
            if (prev.itemMeta != current.itemMeta || initPacket) {
                changed = true;
                renderCache[dir.ordinal()] = new LiquidStack(current.itemID, renderCache[dir.ordinal()].amount, current.itemMeta);
                delta.set(dir.ordinal() * 3 + 1);
            }
            if ((displayQty = (prev.amount * 4 + current.amount) / 5) == 0 && current.amount > 0 || initPacket) {
                displayQty = current.amount;
            }
            if (prev.amount == (displayQty = dir != ForgeDirection.UNKNOWN ? Math.min(this.getSideCapacity(), displayQty) : Math.min(this.getInnerCapacity(), displayQty)) && !initPacket) continue;
            changed = true;
            renderCache[dir.ordinal()].amount = displayQty;
            delta.set(dir.ordinal() * 3 + 2);
        }
        if (persistChange) {
            this.renderCache = renderCache;
        }
        if (changed || initPacket) {
            return ((PipeLiquidUpdate)PacketHandler.getPacket(PipeLiquidUpdate.class)).setRenderCache(renderCache).setDelta(delta).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord).setChunkDataPacket(initPacket);
        }
        return null;
    }

    @Override
    protected boolean isItemExitable(ItemStack stack) {
        return true;
    }
}

