/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.utils.ObfuscationHelper;
import net.minecraft.server.integrated.IntegratedServer;

public class Watchdog
extends Thread {
    private static long timeStempServer = 0L;
    private static long timeStempClient = 0L;
    private final boolean isClient;
    private Field isGamePaused = null;

    public Watchdog(boolean isClient) {
        super("LP Watchdog");
        this.setDaemon(true);
        this.start();
        this.isClient = isClient;
        if (isClient) {
            try {
                this.isGamePaused = ObfuscationHelper.getDeclaredField(ObfuscationHelper.NAMES.isGamePausedServer, IntegratedServer.class);
                this.isGamePaused.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static void tickServer() {
        timeStempServer = System.currentTimeMillis();
    }

    public static void tickClient() {
        timeStempClient = System.currentTimeMillis();
    }

    @Override
    public void run() {
        boolean client;
        boolean server;
        while (true) {
            server = false;
            client = false;
            if (this.isClient) {
                boolean serverPaused = false;
                if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                    if (FMLCommonHandler.instance().getMinecraftServerInstance() instanceof IntegratedServer) {
                        try {
                            serverPaused = this.isGamePaused.getBoolean(FMLCommonHandler.instance().getMinecraftServerInstance());
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71241_aa()) {
                        timeStempServer = 0L;
                    }
                    server |= timeStempServer + (long)Configs.WATCHDOG_TIMEOUT < System.currentTimeMillis() && timeStempServer != 0L && !serverPaused && FMLCommonHandler.instance().getMinecraftServerInstance().func_71278_l();
                } else if (timeStempServer != 0L) {
                    timeStempServer = System.currentTimeMillis();
                }
                if (!FMLClientHandler.instance().getClient().field_71425_J) {
                    timeStempClient = 0L;
                }
                client |= timeStempClient + (long)Configs.WATCHDOG_TIMEOUT < System.currentTimeMillis() && timeStempClient != 0L;
            } else if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_71278_l()) {
                server |= timeStempServer + (long)Configs.WATCHDOG_TIMEOUT < System.currentTimeMillis() && timeStempServer != 0L;
            } else if (timeStempServer != 0L) {
                timeStempServer = System.currentTimeMillis();
            }
            if (server && Configs.WATCHDOG_SERVER || client && Configs.WATCHDOG_CLIENT) break;
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
        }
        Watchdog.dump(server, client, false);
        LogisticsPipes.WATCHDOG = false;
    }

    public static void dump(boolean server, boolean client, boolean dump) {
        ThreadInfo[] threads;
        Logger log = LogisticsPipes.log;
        if (server) {
            log.log(Level.SEVERE, "The server has stopped responding!");
        }
        if (client) {
            log.log(Level.SEVERE, "The client has stopped responding!");
        }
        if (!dump) {
            log.log(Level.SEVERE, "This doesn't have to be a crash.");
            log.log(Level.SEVERE, "But still, please report this to https://github.com/RS485/LogisticsPipes/issues");
            log.log(Level.SEVERE, "Be sure to include ALL relevant console errors and Minecraft crash reports");
        }
        log.log(Level.SEVERE, "LP version: 0.7.3.ftb.631:false");
        log.log(Level.SEVERE, "Current Thread State:");
        for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
            log.log(Level.SEVERE, "------------------------------");
            log.log(Level.SEVERE, "Current Thread: " + thread.getThreadName());
            log.log(Level.SEVERE, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState()));
            if (thread.getLockedMonitors().length != 0) {
                log.log(Level.SEVERE, "\tThread is waiting on monitor(s):");
                for (MonitorInfo monitor : thread.getLockedMonitors()) {
                    log.log(Level.SEVERE, "\t\tLocked on:" + monitor.getLockedStackFrame());
                }
            }
            if (thread.getThreadState() == Thread.State.WAITING) {
                log.log(Level.SEVERE, "\tWAITING ON: " + thread.getLockInfo().toString());
            }
            log.log(Level.SEVERE, "\tStack:");
            StackTraceElement[] stack = thread.getStackTrace();
            for (int line = 0; line < stack.length; ++line) {
                log.log(Level.SEVERE, "\t\t" + stack[line].toString());
            }
        }
        log.log(Level.SEVERE, "------------------------------");
    }
}

