/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.BufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Pair;
import net.minecraft.network.packet.Packet250CustomPayload;

public class ServerPacketBufferHandlerThread {
    private final ServerCompressorThread serverCompressorThread = new ServerCompressorThread();
    private final ServerDecompressorThread serverDecompressorThread = new ServerDecompressorThread();

    public void setPause(boolean flag) {
        this.serverCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(Packet250CustomPayload packet, Player player) {
        this.serverCompressorThread.addPacketToCompressor(packet, player);
    }

    public void handlePacket(byte[] content, Player player) {
        this.serverDecompressorThread.handlePacket(content, player);
    }

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            int buffer = 0;
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private class ServerDecompressorThread
    extends Thread {
        private final HashMap queue;
        private final HashMap ByteBuffer;
        private final LinkedList PacketBuffer;

        public ServerDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Server");
            this.queue = new HashMap();
            this.ByteBuffer = new HashMap();
            this.PacketBuffer = new LinkedList();
            this.setDaemon(true);
            this.start();
            TickRegistry.registerTickHandler((ITickHandler)new ITickHandler(){

                public EnumSet ticks() {
                    return EnumSet.of(TickType.SERVER);
                }

                public void tickStart(EnumSet type, Object ... tickData) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void tickEnd(EnumSet type, Object ... tickData) {
                    boolean flag = false;
                    do {
                        flag = false;
                        Pair part = null;
                        LinkedList linkedList = ServerDecompressorThread.this.PacketBuffer;
                        synchronized (linkedList) {
                            if (ServerDecompressorThread.this.PacketBuffer.size() > 0) {
                                flag = true;
                                part = (Pair)ServerDecompressorThread.this.PacketBuffer.pop();
                            }
                        }
                        if (!flag) continue;
                        try {
                            PacketHandler.onPacketData(new DataInputStream(new ByteArrayInputStream((byte[])part.getValue2())), (Player)part.getValue1());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } while (flag);
                }

                public String getLabel() {
                    return "LogisticsPipes Packet Compressor Tick Server";
                }
            }, (Side)Side.SERVER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (true) {
                byte[] ByteBufferForPlayer;
                boolean flag = false;
                do {
                    void var3_6;
                    flag = false;
                    byte[] buffer = null;
                    Object interruptedException = null;
                    HashMap hashMap = this.queue;
                    synchronized (hashMap) {
                        if (this.queue.size() > 0) {
                            Iterator it = this.queue.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry lPlayer = it.next();
                                if (((LinkedList)lPlayer.getValue()).size() > 0) {
                                    flag = true;
                                    buffer = (byte[])((LinkedList)lPlayer.getValue()).getFirst();
                                    Player player = (Player)lPlayer.getKey();
                                    if (((LinkedList)lPlayer.getValue()).size() > 1) {
                                        ((LinkedList)lPlayer.getValue()).removeFirst();
                                        break;
                                    }
                                    it.remove();
                                    break;
                                }
                                it.remove();
                            }
                        }
                    }
                    if (!flag || buffer == null || var3_6 == null) continue;
                    ByteBufferForPlayer = (byte[])this.ByteBuffer.get(var3_6);
                    if (ByteBufferForPlayer == null) {
                        ByteBufferForPlayer = new byte[]{};
                        this.ByteBuffer.put(var3_6, ByteBufferForPlayer);
                    }
                    byte[] packetbytes = ServerPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + ByteBufferForPlayer.length];
                    System.arraycopy(ByteBufferForPlayer, 0, newBuffer, 0, ByteBufferForPlayer.length);
                    System.arraycopy(packetbytes, 0, newBuffer, ByteBufferForPlayer.length, packetbytes.length);
                    this.ByteBuffer.put(var3_6, newBuffer);
                } while (flag);
                for (Map.Entry entry : this.ByteBuffer.entrySet()) {
                    int size;
                    while (((byte[])entry.getValue()).length >= 4 && (size = (((ByteBufferForPlayer = (byte[])entry.getValue())[0] & 0xFF) << 24) + ((ByteBufferForPlayer[1] & 0xFF) << 16) + ((ByteBufferForPlayer[2] & 0xFF) << 8) + ((ByteBufferForPlayer[3] & 0xFF) << 0)) + 4 <= ByteBufferForPlayer.length) {
                        byte[] packet = Arrays.copyOfRange(ByteBufferForPlayer, 4, size + 4);
                        ByteBufferForPlayer = Arrays.copyOfRange(ByteBufferForPlayer, size + 4, ByteBufferForPlayer.length);
                        entry.setValue(ByteBufferForPlayer);
                        LinkedList linkedList = this.PacketBuffer;
                        synchronized (linkedList) {
                            this.PacketBuffer.add(new Pair(entry.getKey(), packet));
                        }
                    }
                }
                Iterator it = this.ByteBuffer.values().iterator();
                while (it.hasNext()) {
                    byte[] byArray = (byte[])it.next();
                    if (byArray.length != 0) continue;
                    it.remove();
                }
                HashMap hashMap = this.queue;
                synchronized (hashMap) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(byte[] content, Player player) {
            HashMap hashMap = this.queue;
            synchronized (hashMap) {
                LinkedList<byte[]> list = (LinkedList<byte[]>)this.queue.get(player);
                if (list == null) {
                    list = new LinkedList<byte[]>();
                    this.queue.put(player, list);
                }
                list.addLast(content);
                this.queue.notify();
            }
        }
    }

    private class ServerCompressorThread
    extends Thread {
        private final HashMap serverList;
        private final HashMap serverBuffer;
        private boolean pause;

        public ServerCompressorThread() {
            super("LogisticsPipes Packet Compressor Server");
            this.serverList = new HashMap();
            this.serverBuffer = new HashMap();
            this.pause = false;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.serverList;
                    synchronized (hashMap) {
                        if (!this.pause) {
                            for (Map.Entry player : this.serverList.entrySet()) {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                DataOutputStream data = new DataOutputStream(out);
                                byte[] towrite = (byte[])this.serverBuffer.get(player.getKey());
                                if (towrite != null) {
                                    data.write(towrite);
                                }
                                LinkedList packets = (LinkedList)player.getValue();
                                for (Packet250CustomPayload packet : packets) {
                                    data.writeInt(packet.field_73629_c.length);
                                    data.write(packet.field_73629_c);
                                }
                                this.serverBuffer.put(player.getKey(), out.toByteArray());
                            }
                            this.serverList.clear();
                        }
                    }
                    for (Map.Entry entry : this.serverBuffer.entrySet()) {
                        byte[] sendbuffer;
                        while (((byte[])entry.getValue()).length > 32768) {
                            sendbuffer = Arrays.copyOf((byte[])entry.getValue(), 32768);
                            byte[] newbuffer = Arrays.copyOfRange((byte[])entry.getValue(), 32768, ((byte[])entry.getValue()).length);
                            entry.setValue(newbuffer);
                            byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                            MainProxy.sendPacketToPlayer(((BufferTransfer)PacketHandler.getPacket(BufferTransfer.class)).setContent(compressed), (Player)entry.getKey());
                        }
                        sendbuffer = (byte[])entry.getValue();
                        byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToPlayer(((BufferTransfer)PacketHandler.getPacket(BufferTransfer.class)).setContent(compressed), (Player)entry.getKey());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverBuffer.clear();
                hashMap = this.serverList;
                synchronized (hashMap) {
                    while (this.pause || this.serverList.size() == 0) {
                        try {
                            this.serverList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(Packet250CustomPayload packet, Player player) {
            if (packet.field_73630_a.equals("BCLP")) {
                HashMap hashMap = this.serverList;
                synchronized (hashMap) {
                    LinkedList<Packet250CustomPayload> packetList = (LinkedList<Packet250CustomPayload>)this.serverList.get(player);
                    if (packetList == null) {
                        packetList = new LinkedList<Packet250CustomPayload>();
                        this.serverList.put(player, packetList);
                    }
                    packetList.add(packet);
                    if (!this.pause) {
                        this.serverList.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            HashMap hashMap = this.serverList;
            synchronized (hashMap) {
                this.pause = flag;
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }
    }
}

