/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.SingleIntervalHandler;
import cpw.mods.fml.common.TickType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.GuiReopenPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.ObfuscationHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class RenderTickHandler
implements ITickHandler {
    private long renderTicks = 0L;
    private static Queue guiPos = new LinkedList();
    private int emptyCounter = 0;
    private int fullCounter = 0;
    private Field ticks;
    private Field wrapper;

    public RenderTickHandler() {
        try {
            this.ticks = FMLCommonHandler.class.getDeclaredField("scheduledClientTicks");
            this.ticks.setAccessible(true);
            this.wrapper = SingleIntervalHandler.class.getDeclaredField("wrapped");
            this.wrapper.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.RENDER) && LogisticsHUDRenderer.instance().displayRenderer()) {
            try {
                int i;
                List old = (List)this.ticks.get(FMLCommonHandler.instance());
                ArrayList newList = new ArrayList(old.size());
                BitSet handled = new BitSet(old.size());
                for (i = 0; i < old.size(); ++i) {
                    ITickHandler tick;
                    IScheduledTickHandler handler = (IScheduledTickHandler)old.get(i);
                    if (!(handler instanceof SingleIntervalHandler) || (tick = (ITickHandler)this.wrapper.get(handler)) != this) continue;
                    newList.add(old.get(i));
                    handled.set(i);
                    break;
                }
                for (i = 0; i < old.size(); ++i) {
                    if (handled.get(i)) continue;
                    newList.add(old.get(i));
                }
                this.ticks.set(FMLCommonHandler.instance(), newList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Method getSetupCameraTransformMethod() throws NoSuchMethodException {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Class<?> start = mc.field_71460_t.getClass();
        while (!start.equals(Object.class)) {
            try {
                return ObfuscationHelper.getDeclaredMethod(ObfuscationHelper.NAMES.setupCameraTransform, start, Float.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                start = start.getSuperclass();
            }
        }
        throw new NoSuchMethodException("Can't find setupCameraTransform or a to display HUD");
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.RENDER)) {
            ++this.renderTicks;
            if (LogisticsHUDRenderer.instance().displayRenderer()) {
                GL11.glPushMatrix();
                Minecraft mc = FMLClientHandler.instance().getClient();
                try {
                    Method camera = this.getSetupCameraTransformMethod();
                    camera.setAccessible(true);
                    camera.invoke((Object)mc.field_71460_t, tickData[0], 1);
                    ActiveRenderInfo.func_74583_a((EntityPlayer)mc.field_71439_g, (mc.field_71474_y.field_74320_O == 2 ? 1 : 0) != 0);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                LogisticsHUDRenderer.instance().renderWorldRelative(this.renderTicks, ((Float)tickData[0]).floatValue());
                mc.field_71460_t.func_78478_c();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                LogisticsHUDRenderer.instance().renderPlayerDisplay(this.renderTicks);
                GL11.glPopMatrix();
            }
            if (!guiPos.isEmpty()) {
                GuiEntry part;
                if (FMLClientHandler.instance().getClient().field_71462_r == null) {
                    this.fullCounter = 0;
                    ++this.emptyCounter;
                    if (this.emptyCounter > 5) {
                        part = (GuiEntry)guiPos.peek();
                        if (part.isActive()) {
                            part = (GuiEntry)guiPos.poll();
                            MainProxy.sendPacketToServer(((GuiReopenPacket)PacketHandler.getPacket(GuiReopenPacket.class)).setGuiID(part.getGuiID()).setPosX(part.getXCoord()).setPosY(part.getYCoord()).setPosZ(part.getZCoord()));
                        }
                        this.emptyCounter = 0;
                    }
                } else {
                    this.emptyCounter = 0;
                    ++this.fullCounter;
                    if (this.fullCounter > 5) {
                        part = (GuiEntry)guiPos.peek();
                        part.setActive(true);
                        this.fullCounter = 0;
                    }
                }
            }
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "LogisticsPipes Renderer";
    }

    public static void addGuiToReopen(int xCoord, int yCoord, int zCoord, int guiID) {
        guiPos.add(new GuiEntry(xCoord, yCoord, zCoord, guiID, false));
    }

    private static class GuiEntry {
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;
        private final int guiID;
        private boolean isActive;

        @ConstructorProperties(value={"xCoord", "yCoord", "zCoord", "guiID", "isActive"})
        public GuiEntry(int xCoord, int yCoord, int zCoord, int guiID, boolean isActive) {
            this.xCoord = xCoord;
            this.yCoord = yCoord;
            this.zCoord = zCoord;
            this.guiID = guiID;
            this.isActive = isActive;
        }

        public int getXCoord() {
            return this.xCoord;
        }

        public int getYCoord() {
            return this.yCoord;
        }

        public int getZCoord() {
            return this.zCoord;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }
}

