/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.textures;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderEngine;

public class OverlayManager {
    public static BufferedImage generateOverlay(String bg, String fg) throws IOException {
        String basicpath = "/mods/logisticspipes/textures/blocks";
        BufferedImage image = OverlayManager.loadImageFromTexturePack(Minecraft.func_71410_x().field_71446_o, basicpath + "/" + bg);
        BufferedImage overlay = OverlayManager.loadImageFromTexturePack(Minecraft.func_71410_x().field_71446_o, basicpath + "/" + fg);
        int w = Math.max(image.getWidth(), overlay.getWidth());
        int h = Math.max(image.getHeight(), overlay.getHeight());
        BufferedImage combined = new BufferedImage(w, h, 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.drawImage((Image)overlay, 0, 0, null);
        g.dispose();
        return combined;
    }

    public static BufferedImage loadImageFromTexturePack(RenderEngine renderEngine, String path) throws IOException {
        InputStream image = Minecraft.func_71410_x().field_71418_C.func_77292_e().func_77532_a(path);
        if (image == null) {
            throw new RuntimeException(String.format("The requested image path %s is not found", path));
        }
        BufferedImage result = ImageIO.read(image);
        if (result == null) {
            throw new RuntimeException(String.format("The requested image path %s appears to be corrupted", path));
        }
        return result;
    }
}

