/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.api.transport.IPassiveItemContribution;
import java.util.LinkedList;
import java.util.UUID;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.RoutedEntityItem;
import net.minecraft.nbt.NBTTagCompound;

public class RoutedEntityItemSaveHandler
implements IPassiveItemContribution {
    private RoutedEntityItem routedEntityItem;
    public UUID destinationUUID;
    public int bufferCounter = 0;
    public boolean arrived;
    public IRoutedItem.TransportMode transportMode = IRoutedItem.TransportMode.Unknown;
    public LinkedList relays = new LinkedList();

    public RoutedEntityItemSaveHandler() {
    }

    public RoutedEntityItemSaveHandler(RoutedEntityItem routedEntityItem) {
        this.routedEntityItem = routedEntityItem;
    }

    private void extract() {
        if (this.routedEntityItem != null) {
            this.destinationUUID = this.routedEntityItem.destinationUUID;
            this.bufferCounter = this.routedEntityItem.getBufferCounter();
            this.arrived = this.routedEntityItem.arrived;
            this.transportMode = this.routedEntityItem.getTransportMode();
            this.relays.clear();
            this.relays.addAll(this.routedEntityItem.relays);
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("destinationUUID")) {
            this.destinationUUID = UUID.fromString(nbttagcompound.func_74779_i("destinationUUID"));
        }
        this.arrived = nbttagcompound.func_74767_n("arrived");
        this.bufferCounter = nbttagcompound.func_74762_e("bufferCounter");
        this.transportMode = IRoutedItem.TransportMode.values()[nbttagcompound.func_74762_e("transportMode")];
        this.relays.clear();
        int size = nbttagcompound.func_74762_e("relaysSize");
        for (int i = 0; i < size; ++i) {
            this.relays.add(SimpleServiceLocator.routerManager.getIDforUUID(UUID.fromString(nbttagcompound.func_74779_i("relays" + i))));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.extract();
        if (this.destinationUUID != null) {
            nbttagcompound.func_74778_a("destinationUUID", this.destinationUUID.toString());
        }
        nbttagcompound.func_74757_a("arrived", this.arrived);
        nbttagcompound.func_74768_a("bufferCounter", this.bufferCounter);
        nbttagcompound.func_74768_a("transportMode", this.transportMode.ordinal());
        nbttagcompound.func_74768_a("relaysSize", this.relays.size());
        for (int i = 0; i < this.relays.size(); ++i) {
            nbttagcompound.func_74778_a("relays" + i, SimpleServiceLocator.routerManager.getRouter((Integer)this.relays.get(i)).getId().toString());
        }
    }
}

